/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.CriticalDepth;
import edu.sc.seis.TauP.DepthRange;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SphericalSModel;
import edu.sc.seis.TauP.SplitLayerInfo;
import edu.sc.seis.TauP.TauPConfig;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelMaterial;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class SlownessModel
implements Serializable {
    public static boolean DEBUG = TauPConfig.DEBUG;
    public static boolean verbose = TauPConfig.VERBOSE;
    protected double radiusOfEarth = 6371.0;
    protected VelocityModel vMod;
    protected List<CriticalDepth> criticalDepths = new ArrayList<CriticalDepth>();
    protected List<DepthRange> highSlownessLayerDepthsP = new ArrayList<DepthRange>();
    protected List<DepthRange> highSlownessLayerDepthsS = new ArrayList<DepthRange>();
    protected List<DepthRange> fluidLayerDepths = new ArrayList<DepthRange>();
    protected static int vectorLength = 256;
    protected List<SlownessLayer> PLayers = new ArrayList<SlownessLayer>(vectorLength);
    protected List<SlownessLayer> SLayers = new ArrayList<SlownessLayer>(vectorLength);
    protected double minDeltaP = 0.1;
    protected double maxDeltaP = 11.0;
    protected double maxDepthInterval = 115.0;
    protected double maxRangeInterval = 200.0 / this.radiusOfEarth;
    protected double maxInterpError = 0.5;
    protected boolean allowInnerCoreS = true;
    public static final double DEFAULT_SLOWNESS_TOLERANCE = 1.0E-16;
    protected double slownessTolerance = 1.0E-16;
    public static final boolean PWAVE = true;
    public static final boolean SWAVE = false;

    public SlownessModel(VelocityModel vMod, double minDeltaP, double maxDeltaP, double maxDepthInterval, double maxRangeInterval, double maxInterpError, boolean allowInnerCoreS, double slownessTolerance) throws NoSuchLayerException, SlownessModelException {
        this.vMod = vMod;
        this.minDeltaP = minDeltaP;
        this.maxDeltaP = maxDeltaP;
        this.maxDepthInterval = maxDepthInterval;
        this.maxRangeInterval = maxRangeInterval;
        this.maxInterpError = maxInterpError;
        this.allowInnerCoreS = allowInnerCoreS;
        this.slownessTolerance = slownessTolerance;
        this.createSample();
    }

    public SlownessModel(double radiusOfEarth, VelocityModel vMod, List<CriticalDepth> criticalDepth, List<DepthRange> highSlownessLayerDepthsP, List<DepthRange> highSlownessLayerDepthsS, List<DepthRange> fluidLayerDepths, List<SlownessLayer> pLayers, List<SlownessLayer> sLayers, double minDeltaP, double maxDeltaP, double maxDepthInterval, double maxRangeInterval, double maxInterpError, boolean allowInnerCoreS, double slownessTolerance) {
        this.radiusOfEarth = radiusOfEarth;
        this.vMod = vMod;
        this.criticalDepths = criticalDepth;
        this.highSlownessLayerDepthsP = highSlownessLayerDepthsP;
        this.highSlownessLayerDepthsS = highSlownessLayerDepthsS;
        this.fluidLayerDepths = fluidLayerDepths;
        this.PLayers = pLayers;
        this.SLayers = sLayers;
        this.minDeltaP = minDeltaP;
        this.maxDeltaP = maxDeltaP;
        this.maxDepthInterval = maxDepthInterval;
        this.maxRangeInterval = maxRangeInterval;
        this.maxInterpError = maxInterpError;
        this.allowInnerCoreS = allowInnerCoreS;
        this.slownessTolerance = slownessTolerance;
    }

    public void setRadiusOfEarth(double radiusOfEarth) {
        this.radiusOfEarth = radiusOfEarth;
    }

    public void setMinDeltaP(double minDeltaP) {
        this.minDeltaP = minDeltaP;
    }

    public void setMaxDeltaP(double maxDeltaP) {
        this.maxDeltaP = maxDeltaP;
    }

    public void setMaxDepthInterval(double maxDepthInterval) {
        this.maxDepthInterval = maxDepthInterval;
    }

    public void setMaxRangeInterval(double maxRangeInterval) {
        this.maxRangeInterval = maxRangeInterval * Math.PI / 180.0;
    }

    public void setMaxInterpError(double maxInterpError) {
        this.maxInterpError = maxInterpError;
    }

    public void setAllowInnerCoreS(boolean allowInnerCoreS) {
        this.allowInnerCoreS = allowInnerCoreS;
    }

    public void setSlownessTolerance(double slownessTolerance) {
        this.slownessTolerance = slownessTolerance;
    }

    public VelocityModel getVelocityModel() {
        return this.vMod;
    }

    public final double getRadiusOfEarth() {
        return this.radiusOfEarth;
    }

    public final double getMinDeltaP() {
        return this.minDeltaP;
    }

    public final double getMaxDeltaP() {
        return this.maxDeltaP;
    }

    public final double getMaxDepthInterval() {
        return this.maxDepthInterval;
    }

    public final double getMaxRangeInterval() {
        return 180.0 * this.maxRangeInterval / Math.PI;
    }

    public final double getMaxInterpError() {
        return this.maxInterpError;
    }

    public final boolean isAllowInnerCoreS() {
        return this.allowInnerCoreS;
    }

    public final double getSlownessTolerance() {
        return this.slownessTolerance;
    }

    public final int getNumCriticalDepths() {
        return this.criticalDepths.size();
    }

    public final CriticalDepth getCriticalDepth(int i) {
        return this.criticalDepths.get(i);
    }

    public final int getNumLayers(boolean isPWave) {
        if (isPWave) {
            return this.PLayers.size();
        }
        return this.SLayers.size();
    }

    public double getMinTurnRayParam(double depth, boolean isPWave) throws NoSuchLayerException, SlownessModelException {
        return this.getMinTurnRayParam(0.0, depth, isPWave);
    }

    public double getMinTurnRayParam(double topDepth, double depth, boolean isPWave) throws NoSuchLayerException, SlownessModelException {
        SlownessLayer topLayer = this.getSlownessLayer(this.layerNumberBelow(topDepth, isPWave), isPWave);
        double minPSoFar = topLayer.getTopP();
        if (this.depthInHighSlowness(depth, Double.MAX_VALUE, isPWave)) {
            int topLNum = 0;
            if (topDepth > 0.0) {
                topLNum = this.layerNumberBelow(topDepth, isPWave);
            }
            int botLNum = this.layerNumberBelow(depth, isPWave) - 1;
            for (int i = topLNum; i < botLNum; ++i) {
                SlownessLayer sLayer = this.getSlownessLayer(i, isPWave);
                if (sLayer.getBotDepth() == depth) {
                    minPSoFar = Math.min(minPSoFar, sLayer.getBotP());
                    return minPSoFar;
                }
                if (sLayer.getBotDepth() > depth) {
                    minPSoFar = Math.min(minPSoFar, sLayer.evaluateAt_bullen(depth, this.getRadiusOfEarth()));
                    return minPSoFar;
                }
                minPSoFar = Math.min(minPSoFar, sLayer.getBotP());
            }
        } else {
            SlownessLayer sLayer = this.getSlownessLayer(this.layerNumberAbove(depth, isPWave), isPWave);
            minPSoFar = depth == sLayer.getBotDepth() ? sLayer.getBotP() : sLayer.evaluateAt_bullen(depth, this.getRadiusOfEarth());
        }
        return minPSoFar;
    }

    public double getMinRayParam(double depth, boolean isPWave) throws NoSuchLayerException, SlownessModelException {
        double minPSoFar = this.getMinTurnRayParam(depth, isPWave);
        int i = this.layerNumberAbove(depth, isPWave);
        int j = this.layerNumberBelow(depth, isPWave);
        SlownessLayer sLayerAbove = this.getSlownessLayer(i, isPWave);
        SlownessLayer sLayerBelow = this.getSlownessLayer(j, isPWave);
        if (sLayerAbove.getBotDepth() == depth) {
            minPSoFar = Math.min(Math.min(minPSoFar, sLayerAbove.getBotP()), sLayerBelow.getTopP());
        }
        return minPSoFar;
    }

    public DepthRange[] getHighSlowness(boolean isPWave) {
        List<DepthRange> highSlownessLayerDepths = isPWave ? this.highSlownessLayerDepthsP : this.highSlownessLayerDepthsS;
        DepthRange[] hsz = new DepthRange[highSlownessLayerDepths.size()];
        for (int i = 0; i < highSlownessLayerDepths.size(); ++i) {
            hsz[i] = (DepthRange)highSlownessLayerDepths.get(i).clone();
        }
        return hsz;
    }

    public SlownessLayer getSlownessLayer(int layerNum, boolean isPWave) {
        if (isPWave) {
            return this.PLayers.get(layerNum);
        }
        return this.SLayers.get(layerNum);
    }

    public List<SlownessLayer> getAllSlownessLayers(boolean isPWave) {
        if (isPWave) {
            return this.PLayers;
        }
        return this.SLayers;
    }

    public abstract double toSlowness(double var1, double var3) throws SlownessModelException;

    public abstract double toVelocity(double var1, double var3) throws SlownessModelException;

    public final TimeDist layerTimeDist(double rayParam, int layerNum, boolean isPWave) throws SlownessModelException {
        return this.layerTimeDist(rayParam, layerNum, isPWave, true);
    }

    public abstract TimeDist layerTimeDist(double var1, int var3, boolean var4, boolean var5) throws SlownessModelException;

    public abstract TimeDist layerTimeDistAllowTurn(double var1, int var3, boolean var4, boolean var5) throws SlownessModelException;

    public abstract SlownessLayer toSlownessLayer(VelocityLayer var1, boolean var2) throws SlownessModelException;

    public abstract double interpolate(double var1, double var3, double var5, double var7) throws SlownessModelException;

    public TimeDist approxDistance(int slownessTurnLayer, double p, boolean isPWave) throws SlownessModelException {
        if (slownessTurnLayer >= this.getNumLayers(isPWave)) {
            throw new SlownessModelException("Can't calculate a distance when slownessTurnLayer >= getNumLayers(" + isPWave + ")\n slownessTurnLayer=" + slownessTurnLayer + " getNumLayers()=" + this.getNumLayers(isPWave));
        }
        if (p < 0.0) {
            throw new SlownessModelException("approxDistance: Ray parameter is negative!!!" + p + " slownessTurnLayer=" + slownessTurnLayer);
        }
        TimeDist td = new TimeDist(p);
        for (int layerNum = 0; layerNum <= slownessTurnLayer; ++layerNum) {
            td = td.add(this.layerTimeDist(p, layerNum, isPWave));
        }
        return new TimeDist(td.getP(), 2.0 * td.getTime(), 2.0 * td.getDistRadian());
    }

    public boolean depthInHighSlowness(double depth, double rayParam, boolean isPWave) {
        DepthRange highSZoneDepth = new DepthRange();
        return this.depthInHighSlowness(depth, rayParam, highSZoneDepth, isPWave);
    }

    public boolean depthInHighSlowness(double depth, double rayParam, DepthRange highSZoneDepth, boolean isPWave) {
        List<DepthRange> highSlownessLayerDepths = isPWave ? this.highSlownessLayerDepthsP : this.highSlownessLayerDepthsS;
        for (int i = 0; i < highSlownessLayerDepths.size(); ++i) {
            DepthRange tempRange = highSlownessLayerDepths.get(i);
            if (!(tempRange.topDepth <= depth) || !(depth <= tempRange.botDepth)) continue;
            highSZoneDepth.topDepth = tempRange.topDepth;
            highSZoneDepth.botDepth = tempRange.botDepth;
            highSZoneDepth.rayParam = tempRange.rayParam;
            if (!(rayParam > tempRange.rayParam) && (rayParam != tempRange.rayParam || depth != tempRange.topDepth)) continue;
            return true;
        }
        return false;
    }

    public boolean depthInFluid(double depth) {
        DepthRange fluidZoneDepth = new DepthRange();
        return this.depthInFluid(depth, fluidZoneDepth);
    }

    public boolean depthInFluid(double depth, DepthRange fluidZoneDepth) {
        for (int i = 0; i < this.fluidLayerDepths.size(); ++i) {
            DepthRange tempRange = this.fluidLayerDepths.get(i);
            if (!(tempRange.topDepth <= depth) || !(depth < tempRange.botDepth)) continue;
            fluidZoneDepth.topDepth = tempRange.topDepth;
            fluidZoneDepth.botDepth = tempRange.botDepth;
            return true;
        }
        return false;
    }

    public SplitLayerInfo splitLayer(double depth, boolean isPWave) throws SlownessModelException, NoSuchLayerException {
        List<SlownessLayer> outSLayers;
        List<SlownessLayer> outPLayers;
        int layerNum = this.layerNumberAbove(depth, isPWave);
        SlownessLayer sLayer = this.getSlownessLayer(layerNum, isPWave);
        if (sLayer.getTopDepth() == depth || sLayer.getBotDepth() == depth) {
            return new SplitLayerInfo(this, false, false, 0.0);
        }
        if (Math.abs(sLayer.getTopDepth() - depth) < 1.0E-6) {
            List<SlownessLayer> outSLayers2;
            List<SlownessLayer> outPLayers2;
            List<SlownessLayer> allLayers = this.getAllSlownessLayers(isPWave);
            ArrayList<SlownessLayer> outLayers = new ArrayList<SlownessLayer>(allLayers.size());
            outLayers.addAll(allLayers);
            outLayers.set(layerNum, new SlownessLayer(sLayer.getTopP(), depth, sLayer.getBotP(), sLayer.getBotDepth()));
            sLayer = this.getSlownessLayer(layerNum - 1, isPWave);
            outLayers.set(layerNum - 1, new SlownessLayer(sLayer.getTopP(), sLayer.getTopDepth(), sLayer.getBotP(), depth));
            if (isPWave) {
                outPLayers2 = outLayers;
                outSLayers2 = this.SLayers;
            } else {
                outPLayers2 = this.PLayers;
                outSLayers2 = outLayers;
            }
            SphericalSModel out = new SphericalSModel(this.radiusOfEarth, this.vMod, this.criticalDepths, this.highSlownessLayerDepthsP, this.highSlownessLayerDepthsS, this.fluidLayerDepths, outPLayers2, outSLayers2, this.minDeltaP, this.maxDeltaP, this.maxDepthInterval, this.maxRangeInterval, this.maxInterpError, this.allowInnerCoreS, this.slownessTolerance);
            return new SplitLayerInfo(out, false, true, sLayer.getBotP());
        }
        if (Math.abs(depth - sLayer.getBotDepth()) < 1.0E-6) {
            List<SlownessLayer> outSLayers3;
            List<SlownessLayer> outPLayers3;
            List<SlownessLayer> allLayers = this.getAllSlownessLayers(isPWave);
            ArrayList<SlownessLayer> outLayers = new ArrayList<SlownessLayer>(allLayers.size());
            outLayers.addAll(allLayers);
            outLayers.set(layerNum, new SlownessLayer(sLayer.getTopP(), sLayer.getTopDepth(), sLayer.getBotP(), depth));
            sLayer = this.getSlownessLayer(layerNum + 1, isPWave);
            outLayers.set(layerNum + 1, new SlownessLayer(sLayer.getTopP(), depth, sLayer.getBotP(), sLayer.getBotDepth()));
            if (isPWave) {
                outPLayers3 = outLayers;
                outSLayers3 = this.SLayers;
            } else {
                outPLayers3 = this.PLayers;
                outSLayers3 = outLayers;
            }
            SphericalSModel out = new SphericalSModel(this.radiusOfEarth, this.vMod, this.criticalDepths, this.highSlownessLayerDepthsP, this.highSlownessLayerDepthsS, this.fluidLayerDepths, outPLayers3, outSLayers3, this.minDeltaP, this.maxDeltaP, this.maxDepthInterval, this.maxRangeInterval, this.maxInterpError, this.allowInnerCoreS, this.slownessTolerance);
            return new SplitLayerInfo(out, false, true, sLayer.getBotP());
        }
        double p = sLayer.evaluateAt_bullen(depth, this.radiusOfEarth);
        SlownessLayer topLayer = new SlownessLayer(sLayer.getTopP(), sLayer.getTopDepth(), p, depth);
        SlownessLayer botLayer = new SlownessLayer(p, depth, sLayer.getBotP(), sLayer.getBotDepth());
        List<SlownessLayer> allLayers = this.getAllSlownessLayers(isPWave);
        ArrayList<SlownessLayer> outLayers = new ArrayList<SlownessLayer>(allLayers.size());
        outLayers.addAll(allLayers);
        outLayers.remove(layerNum);
        outLayers.add(layerNum, botLayer);
        outLayers.add(layerNum, topLayer);
        ArrayList<CriticalDepth> outCriticalDepths = new ArrayList<CriticalDepth>();
        outCriticalDepths.addAll(this.criticalDepths);
        this.fixCriticalDepths(outCriticalDepths, layerNum, isPWave);
        if (isPWave) {
            outPLayers = outLayers;
            outSLayers = this.fixOtherLayers(this.SLayers, p, sLayer, topLayer, botLayer, outCriticalDepths, !isPWave);
        } else {
            outPLayers = this.fixOtherLayers(this.PLayers, p, sLayer, topLayer, botLayer, outCriticalDepths, !isPWave);
            outSLayers = outLayers;
        }
        SphericalSModel out = new SphericalSModel(this.radiusOfEarth, this.vMod, outCriticalDepths, this.highSlownessLayerDepthsP, this.highSlownessLayerDepthsS, this.fluidLayerDepths, outPLayers, outSLayers, this.minDeltaP, this.maxDeltaP, this.maxDepthInterval, this.maxRangeInterval, this.maxInterpError, this.allowInnerCoreS, this.slownessTolerance);
        return new SplitLayerInfo(out, true, false, p);
    }

    private void fixCriticalDepths(List<CriticalDepth> criticalDepths, int layerNum, boolean isPWave) {
        for (int i = 0; i < criticalDepths.size(); ++i) {
            CriticalDepth cd = criticalDepths.get(i);
            if (cd.getLayerNum(isPWave) <= layerNum) continue;
            if (isPWave) {
                criticalDepths.set(i, new CriticalDepth(cd.getDepth(), cd.getVelLayerNum(), cd.getPLayerNum() + 1, cd.getSLayerNum()));
                continue;
            }
            criticalDepths.set(i, new CriticalDepth(cd.getDepth(), cd.getVelLayerNum(), cd.getPLayerNum(), cd.getSLayerNum() + 1));
        }
    }

    private List<SlownessLayer> fixOtherLayers(List<SlownessLayer> otherLayers, double p, SlownessLayer changedLayer, SlownessLayer newTopLayer, SlownessLayer newBotLayer, List<CriticalDepth> criticalDepths, boolean isPWave) throws SlownessModelException {
        ArrayList<SlownessLayer> out = new ArrayList<SlownessLayer>();
        out.addAll(otherLayers);
        int otherIndex = otherLayers.indexOf(changedLayer);
        if (otherIndex != -1) {
            out.remove(otherIndex);
            out.add(otherIndex, newBotLayer);
            out.add(otherIndex, newTopLayer);
        }
        for (int otherLayerNum = 0; otherLayerNum < out.size(); ++otherLayerNum) {
            SlownessLayer sLayer = (SlownessLayer)out.get(otherLayerNum);
            if (!((sLayer.getTopP() - p) * (p - sLayer.getBotP()) > 0.0)) continue;
            SlownessLayer topLayer = new SlownessLayer(sLayer.getTopP(), sLayer.getTopDepth(), p, sLayer.bullenDepthFor(p, this.radiusOfEarth));
            SlownessLayer botLayer = new SlownessLayer(p, topLayer.getBotDepth(), sLayer.getBotP(), sLayer.getBotDepth());
            out.remove(otherLayerNum);
            out.add(otherLayerNum, botLayer);
            out.add(otherLayerNum, topLayer);
            this.fixCriticalDepths(criticalDepths, otherLayerNum, !isPWave);
            ++otherLayerNum;
        }
        return out;
    }

    protected void findCriticalPoints() throws SlownessModelException {
        int layerNum;
        double minPSoFar = Double.MAX_VALUE;
        double minSSoFar = Double.MAX_VALUE;
        DepthRange highSlownessZoneP = new DepthRange();
        DepthRange highSlownessZoneS = new DepthRange();
        boolean inHighSlownessZoneP = false;
        boolean inHighSlownessZoneS = false;
        DepthRange fluidZone = new DepthRange();
        boolean inFluidZone = false;
        boolean belowOuterCore = false;
        this.highSlownessLayerDepthsP.clear();
        this.highSlownessLayerDepthsS.clear();
        this.criticalDepths.clear();
        this.fluidLayerDepths.clear();
        VelocityLayer currVLayer = this.vMod.getVelocityLayer(0);
        currVLayer = new VelocityLayer(0, currVLayer.getTopDepth(), currVLayer.getTopDepth(), currVLayer.getTopPVelocity(), currVLayer.getTopPVelocity(), currVLayer.getTopSVelocity(), currVLayer.getTopSVelocity(), currVLayer.getTopDensity(), currVLayer.getTopDensity(), currVLayer.getTopQp(), currVLayer.getTopQp(), currVLayer.getTopQs(), currVLayer.getTopQs());
        SlownessLayer currSLayer = this.toSlownessLayer(currVLayer, false);
        SlownessLayer currPLayer = this.toSlownessLayer(currVLayer, true);
        this.criticalDepths.add(new CriticalDepth(0.0, 0, 0, 0));
        if (!inFluidZone && currVLayer.getTopSVelocity() == 0.0) {
            inFluidZone = true;
            fluidZone = new DepthRange();
            fluidZone.topDepth = currVLayer.getTopDepth();
            currSLayer = currPLayer;
        }
        if (minSSoFar > currSLayer.getTopP()) {
            minSSoFar = currSLayer.getTopP();
        }
        if (minPSoFar > currPLayer.getTopP()) {
            minPSoFar = currPLayer.getTopP();
        }
        for (layerNum = 0; layerNum < this.vMod.getNumLayers(); ++layerNum) {
            VelocityLayer prevVLayer = currVLayer;
            SlownessLayer prevSLayer = currSLayer;
            SlownessLayer prevPLayer = currPLayer;
            currVLayer = this.vMod.getVelocityLayerClone(layerNum);
            if (!inFluidZone && currVLayer.getTopSVelocity() == 0.0) {
                inFluidZone = true;
                fluidZone = new DepthRange();
                fluidZone.topDepth = currVLayer.getTopDepth();
            }
            if (inFluidZone && currVLayer.getTopSVelocity() != 0.0) {
                if (prevVLayer.getBotDepth() > this.vMod.getIocbDepth()) {
                    belowOuterCore = true;
                }
                inFluidZone = false;
                fluidZone.botDepth = prevVLayer.getBotDepth();
                this.fluidLayerDepths.add(fluidZone);
            }
            currPLayer = this.toSlownessLayer(currVLayer, true);
            currSLayer = inFluidZone || belowOuterCore && !this.allowInnerCoreS ? currPLayer : this.toSlownessLayer(currVLayer, false);
            if (prevSLayer.getBotP() != currSLayer.getTopP() || prevPLayer.getBotP() != currPLayer.getTopP()) {
                this.criticalDepths.add(new CriticalDepth(currSLayer.getTopDepth(), layerNum, -1, -1));
                if (DEBUG) {
                    Alert.debug("first order discontinuity, depth=" + currSLayer.getTopDepth());
                    Alert.debug(String.valueOf(prevSLayer) + "\n" + String.valueOf(currSLayer));
                    Alert.debug(String.valueOf(prevPLayer) + "\n" + String.valueOf(currPLayer));
                }
                if (inHighSlownessZoneS && currSLayer.getTopP() < highSlownessZoneS.rayParam) {
                    if (DEBUG) {
                        Alert.debug("top of current layer is the bottom of a high slowness zone.");
                    }
                    highSlownessZoneS.botDepth = currSLayer.getTopDepth();
                    this.highSlownessLayerDepthsS.add(highSlownessZoneS);
                    inHighSlownessZoneS = false;
                }
                if (inHighSlownessZoneP && currPLayer.getTopP() < highSlownessZoneP.rayParam) {
                    if (DEBUG) {
                        Alert.debug("top of current layer is the bottom of a high slowness zone.");
                    }
                    highSlownessZoneP.botDepth = currSLayer.getTopDepth();
                    this.highSlownessLayerDepthsP.add(highSlownessZoneP);
                    inHighSlownessZoneP = false;
                }
                if (minPSoFar > currPLayer.getTopP()) {
                    minPSoFar = currPLayer.getTopP();
                }
                if (minSSoFar > currSLayer.getTopP()) {
                    minSSoFar = currSLayer.getTopP();
                }
                if (!inHighSlownessZoneS && (prevSLayer.getBotP() < currSLayer.getTopP() || currSLayer.getTopP() < currSLayer.getBotP())) {
                    if (DEBUG) {
                        Alert.debug("Found S high slowness at first order discontinuity, layer = " + layerNum + ", depth=" + currSLayer.getTopDepth());
                    }
                    inHighSlownessZoneS = true;
                    highSlownessZoneS = new DepthRange();
                    highSlownessZoneS.topDepth = currSLayer.getTopDepth();
                    highSlownessZoneS.rayParam = Math.min(prevSLayer.getBotP(), currSLayer.getTopP());
                }
                if (!inHighSlownessZoneP && (prevPLayer.getBotP() < currPLayer.getTopP() || currPLayer.getTopP() < currPLayer.getBotP())) {
                    if (DEBUG) {
                        Alert.debug("Found P high slowness at first order discontinuity, layer = " + layerNum + ", depth=" + currPLayer.getTopDepth());
                    }
                    inHighSlownessZoneP = true;
                    highSlownessZoneP = new DepthRange();
                    highSlownessZoneP.topDepth = currPLayer.getTopDepth();
                    highSlownessZoneP.rayParam = minPSoFar;
                    highSlownessZoneP.rayParam = Math.min(prevPLayer.getBotP(), currPLayer.getTopP());
                }
            } else if (layerNum == 0 || layerNum == this.vMod.getNumLayers() || (prevSLayer.getTopP() - prevSLayer.getBotP()) * (prevSLayer.getBotP() - currSLayer.getBotP()) < 0.0 || (prevPLayer.getTopP() - prevPLayer.getBotP()) * (prevPLayer.getBotP() - currPLayer.getBotP()) < 0.0) {
                if (layerNum != 0) {
                    this.criticalDepths.add(new CriticalDepth(currSLayer.getTopDepth(), layerNum, -1, -1));
                }
                if (DEBUG) {
                    Alert.debug("local slowness extrema, depth=" + currSLayer.getTopDepth());
                }
                if (!inHighSlownessZoneP && currPLayer.getTopP() < currPLayer.getBotP()) {
                    if (DEBUG) {
                        Alert.debug("start of a P high slowness zone, local slowness extrema, minPSoFar=" + minPSoFar + " vlayerNum=" + layerNum + " depth=" + currPLayer.getTopDepth());
                    }
                    inHighSlownessZoneP = true;
                    highSlownessZoneP = new DepthRange();
                    highSlownessZoneP.topDepth = currPLayer.getTopDepth();
                    highSlownessZoneS.rayParam = currPLayer.getTopP();
                }
                if (!inHighSlownessZoneS && currSLayer.getTopP() < currSLayer.getBotP()) {
                    if (DEBUG) {
                        Alert.debug("start of a S high slowness zone, local slowness extrema, minSSoFar=" + minSSoFar + " vlayerNum=" + layerNum + " depth=" + currSLayer.getTopDepth());
                    }
                    inHighSlownessZoneS = true;
                    highSlownessZoneS = new DepthRange();
                    highSlownessZoneS.topDepth = currSLayer.getTopDepth();
                    highSlownessZoneS.rayParam = currSLayer.getTopP();
                }
            }
            if (inHighSlownessZoneP && currPLayer.getBotP() < highSlownessZoneP.rayParam) {
                if (DEBUG) {
                    Alert.debug("layer contains the bottom of a P high slowness zone. rp=" + highSlownessZoneP.rayParam + " " + String.valueOf(currPLayer));
                }
                highSlownessZoneP.botDepth = this.findDepth(highSlownessZoneP.rayParam, layerNum, layerNum, true);
                this.highSlownessLayerDepthsP.add(highSlownessZoneP);
                inHighSlownessZoneP = false;
            }
            if (inHighSlownessZoneS && currSLayer.getBotP() < highSlownessZoneS.rayParam) {
                if (DEBUG) {
                    Alert.debug("layer contains the bottom of a S high slowness zone. rp=" + highSlownessZoneS.rayParam + " " + String.valueOf(currSLayer));
                }
                highSlownessZoneS.botDepth = this.findDepth(highSlownessZoneS.rayParam, layerNum, layerNum, currSLayer == currPLayer);
                this.highSlownessLayerDepthsS.add(highSlownessZoneS);
                inHighSlownessZoneS = false;
            }
            if (minPSoFar > currPLayer.getBotP()) {
                minPSoFar = currPLayer.getBotP();
            }
            if (minPSoFar > currPLayer.getTopP()) {
                minPSoFar = currPLayer.getTopP();
            }
            if (minSSoFar > currSLayer.getBotP()) {
                minSSoFar = currSLayer.getBotP();
            }
            if (minSSoFar > currSLayer.getTopP()) {
                minSSoFar = currSLayer.getTopP();
            }
            if (DEBUG && inHighSlownessZoneS) {
                Alert.debug("In S high slowness zone, layerNum = " + layerNum + " rp=" + highSlownessZoneS.rayParam);
            }
            if (!DEBUG || !inHighSlownessZoneP) continue;
            Alert.debug("In P high slowness zone, layerNum = " + layerNum + " rp=" + highSlownessZoneP.rayParam);
        }
        this.criticalDepths.add(new CriticalDepth(this.getRadiusOfEarth(), this.vMod.getNumLayers(), -1, -1));
        if (inHighSlownessZoneS) {
            highSlownessZoneS.botDepth = currVLayer.getBotDepth();
            this.highSlownessLayerDepthsS.add(highSlownessZoneS);
        }
        if (inHighSlownessZoneP) {
            highSlownessZoneP.botDepth = currVLayer.getBotDepth();
            this.highSlownessLayerDepthsP.add(highSlownessZoneP);
        }
        if (inFluidZone) {
            fluidZone.botDepth = currVLayer.getBotDepth();
            this.fluidLayerDepths.add(fluidZone);
        }
        if (DEBUG && !this.criticalDepths.isEmpty()) {
            Object desc = "**** Critical Velocity Layers ************************\n";
            int botCriticalLayerNum = this.criticalDepths.get(0).getVelLayerNum() - 1;
            for (int criticalNum = 1; criticalNum < this.criticalDepths.size(); ++criticalNum) {
                int topCriticalLayerNum = botCriticalLayerNum + 1;
                botCriticalLayerNum = this.criticalDepths.get(criticalNum).getVelLayerNum() - 1;
                desc = (String)desc + " " + topCriticalLayerNum + "," + botCriticalLayerNum;
            }
            Alert.debug((String)desc);
        }
        if (DEBUG) {
            if (!this.highSlownessLayerDepthsP.isEmpty()) {
                Alert.debug("high slowness layer depths P: ");
                for (layerNum = 0; layerNum < this.highSlownessLayerDepthsP.size(); ++layerNum) {
                    Alert.debug("  " + String.valueOf(this.highSlownessLayerDepthsP.get(layerNum)));
                }
            }
            if (!this.highSlownessLayerDepthsS.isEmpty()) {
                Alert.debug("high slowness layer depths S: ");
                for (layerNum = 0; layerNum < this.highSlownessLayerDepthsS.size(); ++layerNum) {
                    Alert.debug("  " + String.valueOf(this.highSlownessLayerDepthsS.get(layerNum)));
                }
            }
        }
        if (!this.validate()) {
            throw new SlownessModelException("Validation Failed!");
        }
    }

    public double findDepth(double rayParam, boolean isPWave) throws SlownessModelException {
        return this.findDepth(rayParam, 0, this.vMod.getNumLayers() - 1, isPWave);
    }

    public double findDepth(double rayParam, double topDepth, double botDepth, boolean isPWave) throws SlownessModelException {
        try {
            int topLayerNum = this.vMod.layerNumberBelow(topDepth);
            if (this.vMod.getVelocityLayer(topLayerNum).getBotDepth() == topDepth) {
                ++topLayerNum;
            }
            int botLayerNum = this.vMod.layerNumberAbove(botDepth);
            return this.findDepth(rayParam, topLayerNum, botLayerNum, isPWave);
        }
        catch (NoSuchLayerException e) {
            throw new SlownessModelException(e.getMessage());
        }
    }

    public double findDepth(double p, int topCriticalLayer, int botCriticalLayer, boolean isPWave) throws SlownessModelException {
        VelocityLayer velLayer = null;
        double topP = Double.MAX_VALUE;
        double botP = Double.MAX_VALUE;
        VelocityModelMaterial waveType = isPWave ? VelocityModelMaterial.P_VELOCITY : VelocityModelMaterial.S_VELOCITY;
        if (topCriticalLayer > botCriticalLayer) {
            throw new SlownessModelException("findDepth: no layers to search!: topCriticalLayer = " + topCriticalLayer + "botCriticalLayer = " + botCriticalLayer);
        }
        for (int layerNum = topCriticalLayer; layerNum <= botCriticalLayer; ++layerNum) {
            velLayer = this.vMod.getVelocityLayer(layerNum);
            double topVelocity = velLayer.evaluateAtTop(waveType);
            double botVelocity = velLayer.evaluateAtBottom(waveType);
            if (topVelocity == 0.0 && botVelocity == 0.0) continue;
            topP = this.toSlowness(topVelocity, velLayer.getTopDepth());
            botP = this.toSlowness(botVelocity, velLayer.getBotDepth());
            if (Math.abs(topP - p) < this.slownessTolerance) {
                return velLayer.getTopDepth();
            }
            if (Math.abs(p - botP) < this.slownessTolerance) {
                return velLayer.getBotDepth();
            }
            if ((topP - p) * (p - botP) >= 0.0) {
                double slope = (botVelocity - topVelocity) / (velLayer.getBotDepth() - velLayer.getTopDepth());
                double depth = this.interpolate(p, topVelocity, velLayer.getTopDepth(), slope);
                return depth;
            }
            if (layerNum == topCriticalLayer && Math.abs(p - topP) < this.slownessTolerance) {
                return velLayer.getTopDepth();
            }
            if (layerNum >= this.vMod.getNumLayers() - 1) continue;
            velLayer = this.vMod.getVelocityLayer(layerNum + 1);
            topVelocity = velLayer.evaluateAtTop(waveType);
            if (!isPWave && this.depthInFluid(velLayer.getTopDepth())) {
                topVelocity = velLayer.evaluateAtTop(VelocityModelMaterial.P_VELOCITY);
            }
            topP = this.toSlowness(topVelocity, velLayer.getTopDepth());
            if (!(botP >= p) || !(p >= topP)) continue;
            return velLayer.getTopDepth();
        }
        if (Math.abs(p - botP) < this.slownessTolerance) {
            if (DEBUG) {
                Alert.debug(" p is just outside the bottommost layer. This probably shouldn't be allowed to happen!\n");
            }
            return velLayer.getBotDepth();
        }
        throw new SlownessModelException("slowness p=" + p + " is not contained within the specified layers.\np=" + p + " topCriticalLayer=" + topCriticalLayer + " botCriticalLayer=" + botCriticalLayer + " isPWave=" + isPWave + " topP=" + topP + " botP=" + botP);
    }

    private void createSample() throws SlownessModelException, NoSuchLayerException {
        if (!this.vMod.validate()) {
            throw new SlownessModelException("Error in velocity model!");
        }
        if (this.vMod.getNumLayers() == 0) {
            throw new SlownessModelException("velModel.getNumLayers()==0");
        }
        VelocityLayer firstVL = this.vMod.getVelocityLayer(0);
        if (DEBUG) {
            Alert.debug("start createSample");
        }
        this.setRadiusOfEarth(this.vMod.getRadiusOfEarth());
        if (DEBUG) {
            Alert.debug("findCriticalPoints");
        }
        this.findCriticalPoints();
        if (DEBUG) {
            Alert.debug("coarseSample");
        }
        this.coarseSample();
        boolean isOK = true;
        if (DEBUG) {
            if (!(isOK &= this.validate())) {
                throw new SlownessModelException("coarseSample RP not compatible");
            }
            Alert.debug("rayParamCheck");
        }
        this.rayParamIncCheck();
        if (DEBUG) {
            if (!(isOK &= this.validate())) {
                throw new SlownessModelException("rayParamIncCheck RP not compatible");
            }
            Alert.debug("depthIncCheck");
        }
        this.depthIncCheck();
        if (DEBUG) {
            if (!(isOK &= this.validate())) {
                throw new SlownessModelException("depthIncCheck RP not compatible");
            }
            Alert.debug("distanceCheck");
        }
        this.distanceCheck();
        if (DEBUG) {
            if (!(isOK &= this.validate())) {
                throw new SlownessModelException("distanceCheck RP not compatible");
            }
            Alert.debug("fixCriticalPoints");
        }
        this.fixCriticalPoints();
        if (DEBUG) {
            if (!(isOK &= this.validate())) {
                throw new SlownessModelException("fixCriticalPoints RP not compatible");
            }
            Alert.debug("done createSample");
        }
    }

    protected void coarseSample() throws SlownessModelException, NoSuchLayerException {
        int j;
        SlownessLayer highSLayer;
        int highZoneNum;
        this.PLayers.clear();
        this.SLayers.clear();
        VelocityLayer origVLayer = this.vMod.getVelocityLayer(0);
        origVLayer = new VelocityLayer(0, origVLayer.getTopDepth(), origVLayer.getTopDepth(), origVLayer.getTopPVelocity(), origVLayer.getTopPVelocity(), origVLayer.getTopSVelocity(), origVLayer.getTopSVelocity(), origVLayer.getTopDensity(), origVLayer.getTopDensity(), origVLayer.getTopQp(), origVLayer.getTopQp(), origVLayer.getTopQs(), origVLayer.getTopQs());
        for (int layerNum = 0; layerNum < this.vMod.getNumLayers(); ++layerNum) {
            SlownessLayer currSLayer;
            SlownessLayer currPLayer;
            VelocityLayer prevVLayer = origVLayer;
            origVLayer = this.vMod.getVelocityLayer(layerNum);
            if (prevVLayer.getBotPVelocity() != origVLayer.getTopPVelocity() || prevVLayer.getBotSVelocity() != origVLayer.getTopSVelocity() && (this.allowInnerCoreS || origVLayer.getTopDepth() < this.vMod.getIocbDepth())) {
                double topSVel = prevVLayer.getBotSVelocity() == 0.0 ? prevVLayer.getBotPVelocity() : prevVLayer.getBotSVelocity();
                double botSVel = origVLayer.getTopSVelocity() == 0.0 ? origVLayer.getTopPVelocity() : origVLayer.getTopSVelocity();
                VelocityLayer currVLayer = new VelocityLayer(layerNum, prevVLayer.getBotDepth(), prevVLayer.getBotDepth(), prevVLayer.getBotPVelocity(), origVLayer.getTopPVelocity(), topSVel, botSVel);
                currPLayer = this.toSlownessLayer(currVLayer, true);
                this.PLayers.add(currPLayer);
                currSLayer = prevVLayer.getBotSVelocity() == 0.0 && origVLayer.getTopSVelocity() == 0.0 || !this.allowInnerCoreS && currVLayer.getTopDepth() >= this.vMod.getIocbDepth() ? currPLayer : this.toSlownessLayer(currVLayer, false);
                this.SLayers.add(currSLayer);
            }
            currPLayer = this.toSlownessLayer(origVLayer, true);
            this.PLayers.add(currPLayer);
            currSLayer = this.depthInFluid(origVLayer.getTopDepth()) || !this.allowInnerCoreS && origVLayer.getTopDepth() >= this.vMod.getIocbDepth() ? currPLayer : this.toSlownessLayer(origVLayer, false);
            this.SLayers.add(currSLayer);
        }
        for (highZoneNum = 0; highZoneNum < this.highSlownessLayerDepthsS.size(); ++highZoneNum) {
            DepthRange highZone = this.highSlownessLayerDepthsS.get(highZoneNum);
            int SLayerNum = this.layerNumberAbove(highZone.botDepth, false);
            highSLayer = this.getSlownessLayer(SLayerNum, false);
            while (highSLayer.getTopDepth() == highSLayer.getBotDepth() && (highSLayer.getTopP() - highZone.rayParam) * (highZone.rayParam - highSLayer.getBotP()) < 0.0) {
                highSLayer = this.getSlownessLayer(++SLayerNum, false);
            }
            if (highZone.rayParam == highSLayer.getBotP()) continue;
            this.addSlowness(highZone.rayParam, false);
        }
        for (highZoneNum = 0; highZoneNum < this.highSlownessLayerDepthsP.size(); ++highZoneNum) {
            DepthRange highZone = this.highSlownessLayerDepthsP.get(highZoneNum);
            int SLayerNum = this.layerNumberAbove(highZone.botDepth, true);
            highSLayer = this.getSlownessLayer(SLayerNum, true);
            while (highSLayer.getTopDepth() == highSLayer.getBotDepth() && (highSLayer.getTopP() - highZone.rayParam) * (highZone.rayParam - highSLayer.getBotP()) < 0.0) {
                highSLayer = this.getSlownessLayer(++SLayerNum, true);
            }
            if (highZone.rayParam == highSLayer.getBotP()) continue;
            this.addSlowness(highZone.rayParam, true);
        }
        double botP = -1.0;
        double topP = -1.0;
        ArrayList<SlownessLayer> tmpLayers = new ArrayList<SlownessLayer>(this.PLayers);
        for (j = 0; j < tmpLayers.size(); ++j) {
            topP = ((SlownessLayer)tmpLayers.get(j)).getTopP();
            if (topP != botP) {
                this.addSlowness(topP, false);
            }
            botP = ((SlownessLayer)tmpLayers.get(j)).getBotP();
            this.addSlowness(botP, false);
        }
        botP = -1.0;
        tmpLayers = new ArrayList<SlownessLayer>(this.SLayers);
        for (j = 0; j < tmpLayers.size(); ++j) {
            topP = ((SlownessLayer)tmpLayers.get(j)).getTopP();
            if (topP != botP) {
                this.addSlowness(topP, true);
            }
            botP = ((SlownessLayer)tmpLayers.get(j)).getBotP();
            this.addSlowness(botP, true);
        }
    }

    protected void rayParamIncCheck() throws SlownessModelException, NoSuchLayerException {
        int rayNum;
        double deltaP;
        double numNewP;
        SlownessLayer sLayer;
        int j;
        ArrayList<SlownessLayer> tempLayers = new ArrayList<SlownessLayer>(this.SLayers);
        for (j = 0; j < tempLayers.size(); ++j) {
            sLayer = (SlownessLayer)tempLayers.get(j);
            if (!(Math.abs(sLayer.getTopP() - sLayer.getBotP()) > this.maxDeltaP)) continue;
            numNewP = Math.ceil(Math.abs(sLayer.getTopP() - sLayer.getBotP()) / this.maxDeltaP);
            deltaP = (sLayer.getTopP() - sLayer.getBotP()) / numNewP;
            rayNum = 1;
            while ((double)rayNum < numNewP) {
                this.addSlowness(sLayer.getTopP() + (double)rayNum * deltaP, true);
                this.addSlowness(sLayer.getTopP() + (double)rayNum * deltaP, false);
                ++rayNum;
            }
        }
        tempLayers = new ArrayList<SlownessLayer>(this.PLayers);
        for (j = 0; j < tempLayers.size(); ++j) {
            sLayer = (SlownessLayer)tempLayers.get(j);
            if (!(Math.abs(sLayer.getTopP() - sLayer.getBotP()) > this.maxDeltaP)) continue;
            numNewP = Math.ceil(Math.abs(sLayer.getTopP() - sLayer.getBotP()) / this.maxDeltaP);
            deltaP = (sLayer.getTopP() - sLayer.getBotP()) / numNewP;
            rayNum = 1;
            while ((double)rayNum < numNewP) {
                this.addSlowness(sLayer.getTopP() + (double)rayNum * deltaP, true);
                this.addSlowness(sLayer.getTopP() + (double)rayNum * deltaP, false);
                ++rayNum;
            }
        }
    }

    protected void depthIncCheck() throws SlownessModelException, NoSuchLayerException {
        double p;
        int depthNum;
        double deltaDepth;
        int numNewDepths;
        SlownessLayer sLayer;
        int j;
        ArrayList<SlownessLayer> tmpLayers = new ArrayList<SlownessLayer>(this.SLayers);
        for (j = 0; j < tmpLayers.size(); ++j) {
            sLayer = (SlownessLayer)tmpLayers.get(j);
            if (!(sLayer.getBotDepth() - sLayer.getTopDepth() > this.maxDepthInterval)) continue;
            numNewDepths = (int)Math.ceil((sLayer.getBotDepth() - sLayer.getTopDepth()) / this.maxDepthInterval);
            deltaDepth = (sLayer.getBotDepth() - sLayer.getTopDepth()) / (double)numNewDepths;
            for (depthNum = 1; depthNum < numNewDepths; ++depthNum) {
                double velocity = this.vMod.evaluateAbove(sLayer.getTopDepth() + (double)depthNum * deltaDepth, VelocityModelMaterial.S_VELOCITY);
                if (velocity == 0.0 || !this.allowInnerCoreS && sLayer.getTopDepth() + (double)depthNum * deltaDepth >= this.vMod.getIocbDepth()) {
                    velocity = this.vMod.evaluateAbove(sLayer.getTopDepth() + (double)depthNum * deltaDepth, VelocityModelMaterial.P_VELOCITY);
                }
                p = this.toSlowness(velocity, sLayer.getTopDepth() + (double)depthNum * deltaDepth);
                this.addSlowness(p, true);
                this.addSlowness(p, false);
            }
        }
        tmpLayers = new ArrayList<SlownessLayer>(this.PLayers);
        for (j = 0; j < tmpLayers.size(); ++j) {
            sLayer = (SlownessLayer)tmpLayers.get(j);
            if (!(sLayer.getBotDepth() - sLayer.getTopDepth() > this.maxDepthInterval)) continue;
            numNewDepths = (int)Math.ceil((sLayer.getBotDepth() - sLayer.getTopDepth()) / this.maxDepthInterval);
            deltaDepth = (sLayer.getBotDepth() - sLayer.getTopDepth()) / (double)numNewDepths;
            for (depthNum = 1; depthNum < numNewDepths; ++depthNum) {
                p = this.toSlowness(this.vMod.evaluateAbove(sLayer.getTopDepth() + (double)depthNum * deltaDepth, VelocityModelMaterial.P_VELOCITY), sLayer.getTopDepth() + (double)depthNum * deltaDepth);
                this.addSlowness(p, true);
                this.addSlowness(p, false);
            }
        }
    }

    protected void distanceCheck() throws SlownessModelException, NoSuchLayerException {
        for (int waveN = 0; waveN < 2; ++waveN) {
            boolean currWaveType = waveN != 0;
            TimeDist prevPrevTD = null;
            TimeDist prevTD = null;
            TimeDist currTD = null;
            boolean isCurrOK = false;
            boolean isPrevOK = false;
            int j = 0;
            SlownessLayer sLayer = this.getSlownessLayer(0, currWaveType);
            while (j < this.getNumLayers(currWaveType)) {
                SlownessLayer prevSLayer = sLayer;
                sLayer = this.getSlownessLayer(j, currWaveType);
                if (!this.depthInHighSlowness(sLayer.getBotDepth(), sLayer.getBotP(), currWaveType) && !this.depthInHighSlowness(sLayer.getTopDepth(), sLayer.getTopP(), currWaveType)) {
                    if (isCurrOK && currTD != null) {
                        prevPrevTD = isPrevOK ? prevTD : null;
                        prevTD = currTD;
                        isPrevOK = true;
                    } else {
                        prevTD = this.approxDistance(j - 1, sLayer.getTopP(), currWaveType);
                        isPrevOK = true;
                    }
                    currTD = this.approxDistance(j, sLayer.getBotP(), currWaveType);
                    isCurrOK = true;
                    if (Math.abs(prevTD.getDistRadian() - currTD.getDistRadian()) > this.maxRangeInterval && Math.abs(sLayer.getTopP() - sLayer.getBotP()) > 2.0 * this.minDeltaP) {
                        if (DEBUG) {
                            Alert.debug(" " + j + "Dist jump too great: " + Math.abs(prevTD.getDistRadian() - currTD.getDistRadian()) + " > " + this.maxRangeInterval + "  adding slowness: " + (sLayer.getTopP() + sLayer.getBotP()) / 2.0);
                        }
                        this.addSlowness((sLayer.getTopP() + sLayer.getBotP()) / 2.0, true);
                        this.addSlowness((sLayer.getTopP() + sLayer.getBotP()) / 2.0, false);
                        currTD = prevTD;
                        isCurrOK = isPrevOK;
                        prevTD = prevPrevTD;
                        prevPrevTD = null;
                        isPrevOK = prevTD != null;
                        continue;
                    }
                    double splitRayParam = (sLayer.getTopP() + sLayer.getBotP()) / 2.0;
                    TimeDist allButLayer = this.approxDistance(j - 1, splitRayParam, currWaveType);
                    SlownessLayer splitLayer = new SlownessLayer(sLayer.getTopP(), sLayer.getTopDepth(), splitRayParam, sLayer.bullenDepthFor(splitRayParam, this.getRadiusOfEarth()));
                    TimeDist justLayer = splitLayer.bullenRadialSlowness(splitRayParam, this.getRadiusOfEarth(), true);
                    TimeDist splitTD = new TimeDist(splitRayParam, allButLayer.getTime() + 2.0 * justLayer.getTime(), allButLayer.getDistRadian() + 2.0 * justLayer.getDistRadian());
                    if (Math.abs(currTD.getTime() - ((splitTD.getTime() - prevTD.getTime()) * (currTD.getDistRadian() - prevTD.getDistRadian()) / (splitTD.getDistRadian() - prevTD.getDistRadian()) + prevTD.getTime())) > this.maxInterpError) {
                        if (DEBUG) {
                            Alert.debug(" " + j + " add slowness " + Math.abs(currTD.getTime() - ((splitTD.getTime() - prevTD.getTime()) * (currTD.getDistRadian() - prevTD.getDistRadian()) / (splitTD.getDistRadian() - prevTD.getDistRadian()) + prevTD.getTime())) + " > " + this.maxInterpError);
                        }
                        this.addSlowness((prevSLayer.getTopP() + prevSLayer.getBotP()) / 2.0, true);
                        this.addSlowness((prevSLayer.getTopP() + prevSLayer.getBotP()) / 2.0, false);
                        this.addSlowness((sLayer.getTopP() + sLayer.getBotP()) / 2.0, true);
                        this.addSlowness((sLayer.getTopP() + sLayer.getBotP()) / 2.0, false);
                        currTD = prevPrevTD;
                        isCurrOK = currTD != null;
                        isPrevOK = false;
                        if (j > 0) {
                            sLayer = this.getSlownessLayer(--j - 1 >= 0 ? j - 1 : 0, currWaveType);
                            continue;
                        }
                        isPrevOK = false;
                        isCurrOK = false;
                        continue;
                    }
                    if (!DEBUG || ++j % 10 != 0) continue;
                    Alert.debug("  " + j);
                    continue;
                }
                prevPrevTD = null;
                prevTD = null;
                currTD = null;
                isCurrOK = false;
                isPrevOK = false;
                if (!DEBUG || ++j % 100 != 0) continue;
                Alert.debug(" " + j);
            }
            if (!DEBUG) continue;
            Alert.debug("\nNumber of " + String.valueOf((Object)(currWaveType ? VelocityModelMaterial.P_VELOCITY : VelocityModelMaterial.S_VELOCITY)) + " slowness layers: " + j);
        }
    }

    protected void addSlowness(double p, boolean isPWave) throws SlownessModelException, NoSuchLayerException {
        SlownessLayer[] splitLayers;
        SlownessLayer sLayer;
        int i;
        List<SlownessLayer> otherLayers;
        List<SlownessLayer> layers;
        if (isPWave) {
            layers = this.PLayers;
            otherLayers = this.SLayers;
        } else {
            layers = this.SLayers;
            otherLayers = this.PLayers;
        }
        for (i = 0; i < layers.size(); ++i) {
            sLayer = layers.get(i);
            if (!isPWave && !this.allowInnerCoreS && sLayer.getBotDepth() > this.vMod.getIocbDepth()) break;
            if (!((sLayer.getTopP() - p) * (p - sLayer.getBotP()) > 0.0)) continue;
            splitLayers = this.splitLayerForNewRayParam(p, isPWave, sLayer);
            layers.remove(i);
            layers.add(i, splitLayers[1]);
            layers.add(i, splitLayers[0]);
            int otherIndex = otherLayers.indexOf(sLayer);
            if (otherIndex == -1) continue;
            otherLayers.remove(otherIndex);
            otherLayers.add(otherIndex, splitLayers[1]);
            otherLayers.add(otherIndex, splitLayers[0]);
        }
        for (i = 0; i < otherLayers.size(); ++i) {
            sLayer = otherLayers.get(i);
            if (!((sLayer.getTopP() - p) * (p - sLayer.getBotP()) > 0.0)) continue;
            splitLayers = this.splitLayerForNewRayParam(p, !isPWave, sLayer);
            otherLayers.remove(i);
            otherLayers.add(i, splitLayers[1]);
            otherLayers.add(i, splitLayers[0]);
        }
    }

    protected SlownessLayer[] splitLayerForNewRayParam(double p, boolean isPWave, SlownessLayer sLayer) throws SlownessModelException, NoSuchLayerException {
        double botVelocity;
        double topVelocity;
        if (sLayer.getTopDepth() != sLayer.getBotDepth()) {
            topVelocity = this.vMod.evaluateBelow(sLayer.getTopDepth(), isPWave ? VelocityModelMaterial.P_VELOCITY : VelocityModelMaterial.S_VELOCITY);
            botVelocity = this.vMod.evaluateAbove(sLayer.getBotDepth(), isPWave ? VelocityModelMaterial.P_VELOCITY : VelocityModelMaterial.S_VELOCITY);
        } else {
            topVelocity = this.vMod.evaluateAbove(sLayer.getBotDepth(), isPWave ? VelocityModelMaterial.P_VELOCITY : VelocityModelMaterial.S_VELOCITY);
            botVelocity = this.vMod.evaluateBelow(sLayer.getTopDepth(), isPWave ? VelocityModelMaterial.P_VELOCITY : VelocityModelMaterial.S_VELOCITY);
        }
        if (!isPWave && topVelocity == 0.0) {
            if (sLayer.getTopDepth() != sLayer.getBotDepth()) {
                topVelocity = this.vMod.evaluateBelow(sLayer.getTopDepth(), VelocityModelMaterial.P_VELOCITY);
                botVelocity = this.vMod.evaluateAbove(sLayer.getBotDepth(), VelocityModelMaterial.P_VELOCITY);
            } else {
                topVelocity = this.vMod.evaluateAbove(sLayer.getBotDepth(), VelocityModelMaterial.P_VELOCITY);
                botVelocity = this.vMod.evaluateBelow(sLayer.getTopDepth(), VelocityModelMaterial.P_VELOCITY);
            }
        }
        double botDepth = sLayer.getBotDepth();
        if (sLayer.getBotDepth() != sLayer.getTopDepth()) {
            double slope = (botVelocity - topVelocity) / (sLayer.getBotDepth() - sLayer.getTopDepth());
            botDepth = this.interpolate(p, topVelocity, sLayer.getTopDepth(), slope);
            if (botDepth < sLayer.getTopDepth() && botDepth > sLayer.getTopDepth() - 1.0E-11) {
                botDepth = sLayer.getTopDepth();
            }
        }
        SlownessLayer botLayer = new SlownessLayer(p, botDepth, sLayer.getBotP(), sLayer.getBotDepth());
        SlownessLayer topLayer = new SlownessLayer(sLayer.getTopP(), sLayer.getTopDepth(), p, botDepth);
        return new SlownessLayer[]{topLayer, botLayer};
    }

    protected void fixCriticalPoints() throws NoSuchLayerException {
        for (int i = 0; i < this.criticalDepths.size(); ++i) {
            CriticalDepth cd = this.criticalDepths.get(i);
            cd.setPLayerNum(this.layerNumberBelow(cd.getDepth(), true));
            SlownessLayer sLayer = this.getSlownessLayer(cd.getPLayerNum(), true);
            if (cd.getPLayerNum() == this.PLayers.size() - 1 && sLayer.getBotDepth() == cd.getDepth()) {
                cd.setPLayerNum(cd.getPLayerNum() + 1);
            }
            cd.setSLayerNum(this.layerNumberBelow(cd.getDepth(), false));
            sLayer = this.getSlownessLayer(cd.getSLayerNum(), false);
            if (cd.getSLayerNum() != this.SLayers.size() - 1 || sLayer.getBotDepth() != cd.getDepth()) continue;
            cd.setSLayerNum(cd.getSLayerNum() + 1);
        }
    }

    public int layerNumForDepth(double depth, boolean isPWave) throws NoSuchLayerException {
        List<SlownessLayer> layers = isPWave ? this.PLayers : this.SLayers;
        if (depth < layers.get(0).getTopDepth() || layers.get(layers.size() - 1).getBotDepth() < depth) {
            throw new NoSuchLayerException(depth);
        }
        int tooSmallNum = 0;
        int tooLargeNum = layers.size() - 1;
        int currentNum = 0;
        do {
            SlownessLayer tempLayer;
            if (tooLargeNum - tooSmallNum < 3) {
                for (currentNum = tooSmallNum; currentNum <= tooLargeNum; ++currentNum) {
                    tempLayer = this.getSlownessLayer(currentNum, isPWave);
                    if (!tempLayer.containsDepth(depth)) continue;
                    return currentNum;
                }
            } else {
                currentNum = Math.round((float)(tooSmallNum + tooLargeNum) / 2.0f);
            }
            if ((tempLayer = this.getSlownessLayer(currentNum, isPWave)).getTopDepth() > depth) {
                tooLargeNum = currentNum - 1;
                continue;
            }
            if (tempLayer.getBotDepth() < depth) {
                tooSmallNum = currentNum + 1;
                continue;
            }
            return currentNum;
        } while (tooSmallNum <= tooLargeNum);
        throw new RuntimeException("tooSmallNum (" + tooSmallNum + ") >= tooLargeNum (" + tooLargeNum + ")");
    }

    public int layerNumberAbove(double depth, boolean isPWave) throws NoSuchLayerException {
        int foundLayerNum = this.layerNumForDepth(depth, isPWave);
        SlownessLayer tempLayer = this.getSlownessLayer(foundLayerNum, isPWave);
        while (tempLayer.getTopDepth() == depth && foundLayerNum > 0) {
            tempLayer = this.getSlownessLayer(--foundLayerNum, isPWave);
        }
        return foundLayerNum;
    }

    public SlownessLayer layerAbove(double depth, boolean isPWave) throws NoSuchLayerException {
        return this.getSlownessLayer(this.layerNumberAbove(depth, isPWave), isPWave);
    }

    public int layerNumberBelow(double depth, boolean isPWave) throws NoSuchLayerException {
        int foundLayerNum = this.layerNumForDepth(depth, isPWave);
        List<SlownessLayer> layers = isPWave ? this.PLayers : this.SLayers;
        SlownessLayer tempLayer = this.getSlownessLayer(foundLayerNum, isPWave);
        while (tempLayer.getBotDepth() == depth && foundLayerNum < layers.size() - 1) {
            tempLayer = this.getSlownessLayer(++foundLayerNum, isPWave);
        }
        return foundLayerNum;
    }

    public SlownessLayer layerBelow(double depth, boolean isPWave) throws NoSuchLayerException {
        return this.getSlownessLayer(this.layerNumberBelow(depth, isPWave), isPWave);
    }

    public void printGMT(String filename) throws IOException {
        Object psFile = filename == "stdout" ? "taup_slownessmodel" : (filename.endsWith(".gmt") ? filename.substring(0, filename.length() - 4) + ".ps" : filename + ".ps");
        PrintWriter dos = filename == "stdout" ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        dos.println("#!/bin/sh");
        dos.println("#\n# This script will plot the " + this.vMod.getModelName() + " velocity model using GMT. If you want to\n#use this as a data file for psxy in another script, delete these\n# first lines, as well as the last line.\n#");
        dos.println("/bin/rm -f " + (String)psFile + " gmt.history\n");
        double maxP = 0.0;
        for (SlownessLayer sLayer : this.PLayers) {
            if (sLayer.getTopP() > maxP) {
                maxP = sLayer.getTopP();
            }
            if (!(sLayer.getBotP() > maxP)) continue;
            maxP = sLayer.getBotP();
        }
        for (SlownessLayer sLayer : this.SLayers) {
            if (sLayer.getTopP() > maxP) {
                maxP = sLayer.getTopP();
            }
            if (!(sLayer.getBotP() > maxP)) continue;
            maxP = sLayer.getBotP();
        }
        dos.println("PCOLOR=0/0/255");
        dos.println("SCOLOR=255/0/0");
        dos.println();
        dos.println("gmt psbasemap -JX6i/-9i -P -R0/" + (maxP *= 1.05) + "/0/" + this.vMod.getMaxRadius() + " -Bxf100a200+l'Slowness (s/rad)' -Byf200a400+l'Depth (km)' -BWSen+t'" + this.vMod.getModelName() + "'  -K > " + (String)psFile);
        dos.println();
        dos.println("gmt psxy -JX -P -R -W2p,${PCOLOR} -: -m -O -K >> " + (String)psFile + " <<END");
        this.printGMT(dos, true);
        dos.println("END\n");
        dos.println("gmt psxy -JX -P -R -W2p,${SCOLOR} -: -m -O >> " + (String)psFile + " <<END");
        this.printGMT(dos, false);
        dos.println("END\n");
        dos.println("# convert ps to pdf, clean up .ps file");
        dos.println("gmt psconvert -P -Tf  " + (String)psFile + " && rm " + (String)psFile);
        dos.println("# clean up after gmt...");
        dos.println("/bin/rm gmt.history");
        dos.close();
    }

    public void printGMT(PrintWriter dos) {
        dos.println("> P velocity for " + this.vMod.modelName + "  below");
        this.printGMT(dos, true);
        dos.println("> S velocity for " + this.vMod.modelName + "  below");
        this.printGMT(dos, false);
    }

    void printGMT(PrintWriter dos, boolean isPWave) {
        double pVel = -1.0;
        for (int layerNum = 0; layerNum < this.getNumLayers(isPWave); ++layerNum) {
            SlownessLayer currVelocityLayer = this.getSlownessLayer(layerNum, isPWave);
            if (currVelocityLayer.getTopP() != pVel) {
                dos.println((float)currVelocityLayer.getTopDepth() + " " + (float)currVelocityLayer.getTopP());
            }
            dos.println((float)currVelocityLayer.getBotDepth() + " " + (float)currVelocityLayer.getBotP());
            pVel = currVelocityLayer.getBotP();
        }
    }

    public boolean validate() throws SlownessModelException {
        SlownessLayer sLayer;
        double prevDepth;
        boolean isOK = true;
        if (this.radiusOfEarth <= 0.0) {
            throw new SlownessModelException("Radius of earth is not positive. radiusOfEarth = " + this.radiusOfEarth);
        }
        if (this.maxDepthInterval <= 0.0) {
            throw new SlownessModelException("maxDepthInterval is not positive. maxDepthInterval = " + this.maxDepthInterval);
        }
        List<DepthRange> highSlownessLayerDepths = this.highSlownessLayerDepthsP;
        boolean isPWave = true;
        for (int j = 0; j < 2; ++j) {
            highSlownessLayerDepths = isPWave ? this.highSlownessLayerDepthsP : this.highSlownessLayerDepthsS;
            prevDepth = -1.7976931348623157E308;
            for (int i = 0; i < highSlownessLayerDepths.size(); ++i) {
                DepthRange highSZoneDepth = highSlownessLayerDepths.get(i);
                if (highSZoneDepth.topDepth >= highSZoneDepth.botDepth) {
                    throw new SlownessModelException("High slowness zone has zero or negative thickness. Num " + i + " isPWave=" + isPWave + " top depth " + highSZoneDepth.topDepth + " bottom depth " + highSZoneDepth.botDepth);
                }
                if (highSZoneDepth.topDepth <= prevDepth && (highSZoneDepth.topDepth != prevDepth || !this.vMod.isDisconDepth(highSZoneDepth.topDepth))) {
                    throw new SlownessModelException("High slowness zone overlaps previous zone. Num " + i + " isPWave=" + isPWave + " top depth " + highSZoneDepth.topDepth + " bottom depth " + highSZoneDepth.botDepth);
                }
                prevDepth = highSZoneDepth.botDepth;
            }
            isPWave = false;
        }
        prevDepth = -1.7976931348623157E308;
        for (int i = 0; i < this.fluidLayerDepths.size(); ++i) {
            DepthRange fluidZone = this.fluidLayerDepths.get(i);
            if (fluidZone.topDepth >= fluidZone.botDepth) {
                throw new SlownessModelException("Fluid zone has zero or negative thickness. Num " + i + " top depth " + fluidZone.topDepth + " bottom depth " + fluidZone.botDepth);
            }
            if (fluidZone.topDepth <= prevDepth) {
                throw new SlownessModelException("Fluid zone overlaps previous zone. Num " + i + " top depth " + fluidZone.topDepth + " bottom depth " + fluidZone.botDepth);
            }
            prevDepth = fluidZone.botDepth;
        }
        isPWave = true;
        for (int j = 0; j < 2; ++j) {
            double prevBotP;
            prevDepth = 0.0;
            SlownessLayer sLayer2 = null;
            if (this.getNumLayers(isPWave) > 0) {
                sLayer2 = this.getSlownessLayer(0, isPWave);
                prevBotP = sLayer2.getTopP();
            } else {
                prevBotP = -1.0;
            }
            SlownessLayer prevSLayer = null;
            for (int i = 0; i < this.getNumLayers(isPWave); ++i) {
                sLayer2 = this.getSlownessLayer(i, isPWave);
                isOK &= sLayer2.validate();
                if (sLayer2.getTopDepth() > prevDepth) {
                    throw new SlownessModelException("Gap of " + (sLayer2.getTopDepth() - prevDepth) + " between slowness layers. Num " + i + " isPWave=" + isPWave + "  top " + String.valueOf(prevSLayer) + " bottom " + String.valueOf(sLayer2));
                }
                if (sLayer2.getTopDepth() < prevDepth) {
                    throw new SlownessModelException("Slowness layer overlaps previous layer by " + (prevDepth - sLayer2.getTopDepth()) + ". Num " + i + " isPWave=" + isPWave + " top depth " + sLayer2.getTopDepth() + " bottom depth " + sLayer2.getBotDepth());
                }
                if (sLayer2.getTopP() != prevBotP) {
                    throw new SlownessModelException("Slowness layer gap/overlaps previous layer in slowness . Num " + i + " isPWave=" + isPWave + " prevBotP= " + prevBotP + " prevSLayer= " + String.valueOf(prevSLayer) + " sLayer= " + String.valueOf(sLayer2));
                }
                if (Double.isNaN(sLayer2.getTopDepth())) {
                    throw new SlownessModelException("Top depth is NaN, layerNum=" + i + " waveType=" + String.valueOf((Object)(isPWave ? VelocityModelMaterial.P_VELOCITY : VelocityModelMaterial.S_VELOCITY)));
                }
                if (Double.isNaN(sLayer2.getBotDepth())) {
                    throw new SlownessModelException("Top depth is NaN, layerNum=" + i + " waveType=" + String.valueOf((Object)(isPWave ? VelocityModelMaterial.P_VELOCITY : VelocityModelMaterial.S_VELOCITY)));
                }
                prevSLayer = sLayer2;
                prevBotP = sLayer2.getBotP();
                prevDepth = sLayer2.getBotDepth();
            }
            isPWave = false;
        }
        isPWave = true;
        if (this.getNumLayers(isPWave) != 0 && (sLayer = this.getSlownessLayer(this.getNumLayers(isPWave) - 1, isPWave)).getBotP() != 0.0) {
            throw new SlownessModelException("Bot ray param of bottom layer should be zero,  waveType=" + String.valueOf((Object)(isPWave ? VelocityModelMaterial.P_VELOCITY : VelocityModelMaterial.S_VELOCITY)) + "  " + String.valueOf(sLayer));
        }
        isPWave = false;
        if (this.getNumLayers(isPWave) != 0 && (sLayer = this.getSlownessLayer(this.getNumLayers(isPWave) - 1, isPWave)).getBotP() != 0.0) {
            throw new SlownessModelException("Bot ray param of bottom layer should be zero,  waveType=" + String.valueOf((Object)(isPWave ? VelocityModelMaterial.P_VELOCITY : VelocityModelMaterial.S_VELOCITY)) + "  " + String.valueOf(sLayer));
        }
        return isOK &= this.validateRPCompatibility();
    }

    public String toString() {
        int i;
        Object desc = "";
        desc = "radiusOfEarth=" + this.radiusOfEarth + "\n maxDeltaP=" + this.maxDeltaP + "\n minDeltaP=" + this.minDeltaP + "\n maxDepthInterval=" + this.maxDepthInterval + "\n maxRangeInterval=" + this.maxRangeInterval + "\n allowInnerCoreS=" + this.allowInnerCoreS + "\n slownessTolerance=" + this.slownessTolerance + "\n getNumLayers(VelocityModelMaterial.P_VELOCITY)=" + this.getNumLayers(true) + "\n getNumLayers(VelocityModelMaterial.S_VELOCITY)=" + this.getNumLayers(false) + "\n fluidLayerDepths.size()=" + this.fluidLayerDepths.size() + "\n highSlownessLayerDepthsP.size()=" + this.highSlownessLayerDepthsP.size() + "\n highSlownessLayerDepthsS.size()=" + this.highSlownessLayerDepthsS.size() + "\n criticalDepths.size()=" + this.criticalDepths.size() + "\n";
        if (this.criticalDepths.size() != 0) {
            desc = (String)desc + "**** Critical Depth Layers ************************\n";
            int botCriticalLayerNum = this.criticalDepths.get(0).getVelLayerNum() - 1;
            for (int criticalNum = 1; criticalNum < this.criticalDepths.size(); ++criticalNum) {
                int topCriticalLayerNum = botCriticalLayerNum + 1;
                botCriticalLayerNum = this.criticalDepths.get(criticalNum).getVelLayerNum() - 1;
                desc = (String)desc + " " + topCriticalLayerNum + "," + botCriticalLayerNum;
            }
        }
        desc = (String)desc + "\n";
        if (this.fluidLayerDepths.size() != 0) {
            desc = (String)desc + "\n**** Fluid Layer Depths ************************\n";
            for (i = 0; i < this.fluidLayerDepths.size(); ++i) {
                desc = (String)desc + this.fluidLayerDepths.get((int)i).topDepth + "," + this.fluidLayerDepths.get((int)i).botDepth + " ";
            }
        }
        desc = (String)desc + "\n";
        if (!this.highSlownessLayerDepthsP.isEmpty()) {
            desc = (String)desc + "\n**** P High Slowness Layer Depths ****************\n";
            for (i = 0; i < this.highSlownessLayerDepthsP.size(); ++i) {
                desc = (String)desc + this.highSlownessLayerDepthsP.get((int)i).topDepth + "," + this.highSlownessLayerDepthsP.get((int)i).botDepth + " ";
            }
        }
        desc = (String)desc + "\n";
        if (!this.highSlownessLayerDepthsS.isEmpty()) {
            desc = (String)desc + "\n**** S High Slowness Layer Depths ****************\n";
            for (i = 0; i < this.highSlownessLayerDepthsS.size(); ++i) {
                desc = (String)desc + this.highSlownessLayerDepthsS.get((int)i).topDepth + "," + this.highSlownessLayerDepthsS.get((int)i).botDepth + " ";
            }
        }
        desc = (String)desc + "\n";
        desc = (String)desc + "\n**** P Layers ****************\n";
        for (SlownessLayer l : this.PLayers) {
            desc = (String)desc + l.toString() + "\n";
        }
        desc = (String)desc + "\n";
        desc = (String)desc + "\n**** S Layers ****************\n";
        for (SlownessLayer l : this.SLayers) {
            desc = (String)desc + l.toString() + "\n";
        }
        return desc;
    }

    public boolean validateRPCompatibility() {
        int ii;
        int i;
        boolean out = true;
        for (i = 0; i < this.PLayers.size(); ++i) {
            SlownessLayer lp = this.PLayers.get(i);
            for (ii = i + 1; ii < this.PLayers.size(); ++ii) {
                SlownessLayer llp = this.PLayers.get(ii);
                if ((lp.getTopP() - llp.getTopP()) * (lp.getTopP() - llp.getBotP()) < 0.0) {
                    Alert.warning("P top is inside another layer: P:" + String.valueOf(lp) + "  P:" + String.valueOf(llp));
                    out = false;
                }
                if (!((lp.getBotP() - llp.getTopP()) * (lp.getBotP() - llp.getBotP()) < 0.0)) continue;
                Alert.warning("P bot is inside another layer: P:" + String.valueOf(lp) + "  P:" + String.valueOf(llp));
                out = false;
            }
        }
        for (i = 0; i < this.SLayers.size(); ++i) {
            SlownessLayer ls = this.SLayers.get(i);
            for (ii = i + 1; ii < this.SLayers.size(); ++ii) {
                SlownessLayer lls = this.SLayers.get(ii);
                if ((ls.getTopP() - lls.getTopP()) * (ls.getTopP() - lls.getBotP()) < 0.0) {
                    Alert.warning("S top is inside another layer: S:" + String.valueOf(ls) + "  S:" + String.valueOf(lls));
                    out = false;
                }
                if (!((ls.getBotP() - lls.getTopP()) * (ls.getBotP() - lls.getBotP()) < 0.0)) continue;
                Alert.warning("S bot is inside another layer: S:" + String.valueOf(ls) + "  S:" + String.valueOf(lls));
                out = false;
            }
        }
        return out;
    }
}

