/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.cmdline.TauP_AbstractPhaseTool;
import edu.sc.seis.TauP.cmdline.args.AbstractOutputTypeArgs;
import edu.sc.seis.TauP.cmdline.args.DistanceArgs;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import picocli.CommandLine;

public abstract class TauP_AbstractRayTool
extends TauP_AbstractPhaseTool {
    @CommandLine.Mixin
    protected DistanceArgs distanceArgs = new DistanceArgs();

    public TauP_AbstractRayTool(AbstractOutputTypeArgs outputTypeArgs) {
        super(outputTypeArgs);
    }

    public DistanceArgs getDistanceArgs() {
        return this.distanceArgs;
    }

    @Override
    public List<Double> getSourceDepths() throws TauPException {
        List<Double> simpleSourceDepths = this.modelArgs.getSourceDepths();
        ArrayList<Double> out = new ArrayList<Double>();
        HashSet<Double> knownDepths = new HashSet<Double>();
        knownDepths.addAll(simpleSourceDepths);
        for (DistanceRay dr : this.getDistanceArgs().getDistances()) {
            if (!dr.hasSourceDepth()) continue;
            knownDepths.add(dr.getSourceDepth());
        }
        out.addAll(knownDepths);
        if (out.isEmpty()) {
            out.add(Double.parseDouble(this.toolProps.getProperty("taup.source.depth", "0.0")));
        }
        return out;
    }

    @Override
    public List<Double> getReceiverDepths() throws TauPException {
        List<Double> simpleReceiverDepths = this.modelArgs.getReceiverDepths();
        ArrayList<Double> out = new ArrayList<Double>();
        HashSet<Double> knownDepths = new HashSet<Double>();
        knownDepths.addAll(simpleReceiverDepths);
        for (DistanceRay dr : this.getDistanceArgs().getDistances()) {
            if (!dr.hasReceiverDepth()) continue;
            knownDepths.add(dr.getReceiverDepth());
        }
        out.addAll(knownDepths);
        if (out.isEmpty()) {
            out.add(0.0);
        }
        return out;
    }

    @Override
    public void validateArguments() throws TauPException {
        if (this.modelArgs.getTauModel() == null) {
            throw new TauModelException("Model for '" + this.getTauModelName() + "' is null, unable to calculate.");
        }
        for (double sourceDepth : this.modelArgs.getSourceDepths()) {
            if (!(this.modelArgs.getTauModel().getRadiusOfEarth() < sourceDepth)) continue;
            throw new TauModelException("Source depth of " + sourceDepth + " in '" + this.getTauModelName() + "' is greater than radius of earth, " + this.modelArgs.getTauModel().getRadiusOfEarth() + ", unable to calculate.");
        }
        for (Double recDepth : this.modelArgs.getReceiverDepths()) {
            if (!(this.modelArgs.getTauModel().getRadiusOfEarth() < recDepth)) continue;
            throw new TauModelException("Receiver depth of " + recDepth + " in '" + this.getTauModelName() + "' is greater than radius of earth, " + this.modelArgs.getTauModel().getRadiusOfEarth() + ", unable to calculate.");
        }
        if (this.modelArgs.getScatterer() != null && this.modelArgs.getTauModel().getRadiusOfEarth() < this.getScattererDepth()) {
            throw new TauModelException("Scatterer depth of " + this.modelArgs.getScatterer().depth + " in '" + this.getTauModelName() + "' is greater than radius of earth, " + this.modelArgs.getTauModel().getRadiusOfEarth() + ", unable to calculate.");
        }
        this.distanceArgs.validateArguments();
    }

    public abstract List<Arrival> calcAll(List<SeismicPhase> var1, List<RayCalculateable> var2) throws TauPException;

    public abstract void printResult(PrintWriter var1, List<Arrival> var2) throws IOException, TauPException;
}

