/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ExternalReference {
    String uri;
    String description;

    public ExternalReference(String uri, String description) {
        this.uri = uri;
        this.description = description;
    }

    public ExternalReference(XMLEventReader reader, String tagName) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement(tagName, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (this.parseSubElement(elName, reader)) continue;
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    boolean parseSubElement(String elName, XMLEventReader reader) throws StationXMLException, XMLStreamException {
        if (elName.equals("URI")) {
            this.uri = StaxUtil.pullText(reader, "URI");
            return true;
        }
        if (elName.equals("Description")) {
            this.description = StaxUtil.pullText(reader, "Description");
            return true;
        }
        return false;
    }

    void parseAttributes(StartElement startE) throws StationXMLException {
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

