/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.mseed.BtimeComparator;
import edu.sc.seis.seisFile.mseed.Utility;
import java.time.Duration;
import java.time.Instant;
import java.time.Month;
import java.time.ZonedDateTime;
import java.util.TimeZone;

public class Btime {
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public int year = 1960;
    public int jday = 1;
    public int hour = 0;
    public int min = 0;
    public int sec = 0;
    public int tenthMilli = 0;
    public static int MIN_YEAR = 1802;
    public static int MAX_YEAR = 2310;
    public static int MIN_JDAY = 1;
    public static int MAX_JDAY = 366;
    private static BtimeComparator comparator = new BtimeComparator();

    public Btime(Instant date) {
        ZonedDateTime zdt = date.atZone(TimeUtils.TZ_UTC);
        this.setFieldsFromZonedDateTime(zdt);
    }

    private void setFieldsFromZonedDateTime(ZonedDateTime zdt) {
        if (zdt.getOffset().getTotalSeconds() != 0) {
            throw new IllegalArgumentException("Calendar time zone is not UTC: " + String.valueOf(zdt.getZone()));
        }
        this.tenthMilli = zdt.getNano() / 100000;
        this.year = zdt.getYear();
        this.jday = zdt.getDayOfYear();
        this.hour = zdt.getHour();
        this.min = zdt.getMinute();
        this.sec = zdt.getSecond();
    }

    public Btime() {
    }

    public Btime(int year, int jday, int hour, int min, int sec, int tenthMilli) {
        this.year = year;
        this.jday = jday;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.tenthMilli = tenthMilli;
    }

    public Btime(byte[] bytes) {
        this(bytes, 0);
    }

    public Btime(byte[] bytes, int offset) {
        this(bytes, offset, Btime.shouldSwapBytes(bytes, offset));
    }

    public Btime(byte[] bytes, int offset, boolean byteSwapFlag) {
        this.year = Utility.uBytesToInt(bytes[offset], bytes[offset + 1], byteSwapFlag);
        this.jday = Utility.uBytesToInt(bytes[offset + 2], bytes[offset + 3], byteSwapFlag);
        this.hour = bytes[offset + 4] & 0xFF;
        this.min = bytes[offset + 5] & 0xFF;
        this.sec = bytes[offset + 6] & 0xFF;
        this.tenthMilli = Utility.uBytesToInt(bytes[offset + 8], bytes[offset + 9], byteSwapFlag);
    }

    public Btime(double d) {
        this(TimeUtils.instantFromEpochSeconds(d));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.hour;
        result = 31 * result + this.jday;
        result = 31 * result + this.min;
        result = 31 * result + this.sec;
        result = 31 * result + this.tenthMilli;
        result = 31 * result + this.year;
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Btime) {
            Btime oBtime = (Btime)o;
            return oBtime.year == this.year && oBtime.jday == this.jday && oBtime.hour == this.hour && oBtime.min == this.min && oBtime.sec == this.sec && oBtime.tenthMilli == this.tenthMilli;
        }
        return false;
    }

    public boolean before(Btime other) {
        return comparator.compare(this, other) == -1;
    }

    public boolean after(Btime other) {
        return comparator.compare(this, other) == 1;
    }

    public boolean afterOrEquals(Btime other) {
        return comparator.compare(this, other) >= 0;
    }

    public Instant toInstant() {
        if (this.getSec() == 60) {
            throw new RuntimeException("Leap seconds not yet implemented???");
        }
        return ZonedDateTime.of(this.getYear(), Month.JANUARY.getValue(), 1, this.getHour(), this.getMin(), this.getSec(), this.getTenthMilli() * 100000, TimeUtils.TZ_UTC).plus(Duration.ofDays(this.getDayOfYear() - 1)).toInstant();
    }

    public String toString() {
        return "BTime(" + this.year + ":" + this.jday + ":" + this.hour + ":" + this.min + ":" + this.sec + "." + this.tenthMilli + ")";
    }

    public int getYear() {
        return this.year;
    }

    public int getDayOfYear() {
        return this.getJDay();
    }

    public int getJDay() {
        return this.jday;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMin() {
        return this.min;
    }

    public int getSec() {
        return this.sec;
    }

    public int getTenthMilli() {
        return this.tenthMilli;
    }

    public static boolean shouldSwapBytes(byte[] btime) {
        return Btime.shouldSwapBytes(btime, 0);
    }

    public static boolean shouldSwapBytes(byte[] btime, int offset) {
        boolean validYearDay;
        int year = Utility.uBytesToInt(btime[0 + offset], btime[1 + offset], false);
        int jday = Utility.uBytesToInt(btime[offset + 2], btime[offset + 3], false);
        boolean bl = validYearDay = year >= MIN_YEAR && year <= MAX_YEAR && jday >= MIN_JDAY && jday <= MAX_JDAY;
        if (!validYearDay) {
            year = Utility.uBytesToInt(btime[0 + offset], btime[1 + offset], true);
            jday = Utility.uBytesToInt(btime[offset + 2], btime[offset + 3], true);
            if (year >= MIN_YEAR && year <= MAX_YEAR && jday >= MIN_JDAY && jday <= MAX_JDAY) {
                return true;
            }
        }
        return false;
    }

    public byte[] getAsBytes() {
        byte[] bytes = new byte[10];
        System.arraycopy(Utility.intToByteArray(this.year), 2, bytes, 0, 2);
        System.arraycopy(Utility.intToByteArray(this.jday), 2, bytes, 2, 2);
        System.arraycopy(Utility.intToByteArray(this.hour), 3, bytes, 4, 1);
        System.arraycopy(Utility.intToByteArray(this.min), 3, bytes, 5, 1);
        System.arraycopy(Utility.intToByteArray(this.sec), 3, bytes, 6, 1);
        System.arraycopy(Utility.intToByteArray(this.tenthMilli), 2, bytes, 8, 2);
        return bytes;
    }
}

