/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.PhaseInteraction;
import edu.sc.seis.TauP.ProtoSeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class SeismicPhaseWalk {
    public int receiverBranch;
    public double receiverDepth = 0.0;
    Double minRayParam;
    Double maxRayParam;
    TauModel tMod;
    List<Integer> excludeBranch = new ArrayList<Integer>();
    boolean allowSWave = true;
    boolean allowPWave = true;

    public SeismicPhaseWalk(TauModel tMod) throws TauModelException {
        this(tMod, null, null, 0.0);
    }

    public SeismicPhaseWalk(TauModel tMod, Double minRayParam, Double maxRayParam, double receiverDepth) throws TauModelException {
        this.tMod = tMod;
        this.minRayParam = minRayParam;
        this.maxRayParam = maxRayParam;
        this.receiverBranch = tMod.findBranch(receiverDepth);
    }

    public void excludeBoundaries(List<Double> layerDepths) throws TauModelException {
        double tol = 1.0E-6;
        for (double d : layerDepths) {
            int depthBranch = this.tMod.findBranch(d);
            if (Math.abs(this.tMod.getTauBranch(depthBranch, true).getTopDepth() - d) < tol && Math.abs(this.tMod.getTauBranch(depthBranch, true).getTopDepth() - d) < Math.abs(this.tMod.getTauBranch(depthBranch, true).getBotDepth() - d)) {
                this.excludeBranch.add(depthBranch);
                continue;
            }
            if (Math.abs(this.tMod.getTauBranch(depthBranch, true).getBotDepth() - d) < tol) {
                this.excludeBranch.add(depthBranch + 1);
                continue;
            }
            throw new TauModelException("Unable to find discontinuity within " + tol + " km of " + d + " in " + this.tMod.getModelName());
        }
    }

    public List<ProtoSeismicPhase> findEndingPaths(int maxAction) throws TauModelException {
        List<ProtoSeismicPhase> segmentTree = this.walkPhases(maxAction);
        ArrayList<ProtoSeismicPhase> endingSegments = new ArrayList<ProtoSeismicPhase>();
        for (ProtoSeismicPhase proto : segmentTree) {
            SeismicPhaseSegment endSeg = proto.endSegment();
            if (endSeg.endAction != PhaseInteraction.END && endSeg.endAction != PhaseInteraction.END_DOWN) continue;
            ProtoSeismicPhase cons = this.consolidateSegment(proto);
            cons.phaseName = cons.getPuristName();
            endingSegments.add(cons);
        }
        endingSegments.sort(Comparator.naturalOrder());
        ProtoSeismicPhase prev = null;
        ArrayList<ProtoSeismicPhase> out = new ArrayList<ProtoSeismicPhase>();
        for (ProtoSeismicPhase curr : endingSegments) {
            if (prev == null) {
                prev = curr;
                continue;
            }
            if (this.canMergePhases(prev, curr)) {
                prev = this.mergePhases(prev, curr);
                continue;
            }
            out.add(prev);
            prev = curr;
        }
        out.add(prev);
        return out;
    }

    public List<ProtoSeismicPhase> walkPhases(int maxAction) throws TauModelException {
        List<ProtoSeismicPhase> segmentTree = new ArrayList<ProtoSeismicPhase>();
        if (this.allowSWave) {
            segmentTree.addAll(this.createSourceSegments(this.tMod, false, this.receiverDepth));
        }
        if (this.allowPWave) {
            segmentTree.addAll(this.createSourceSegments(this.tMod, true, this.receiverDepth));
        }
        segmentTree = this.overlapsRayParam(segmentTree, this.minRayParam, this.maxRayParam);
        segmentTree = this.walkPhases(this.tMod, segmentTree, maxAction);
        return segmentTree;
    }

    public List<ProtoSeismicPhase> createSourceSegments(TauModel tMod, boolean isPWave, double receiverDepth) {
        ArrayList<ProtoSeismicPhase> segmentTree = new ArrayList<ProtoSeismicPhase>();
        if (tMod.getSourceBranch() > 0) {
            ProtoSeismicPhase upProto;
            int aboveStartBranch = ProtoSeismicPhase.findEndDiscon(tMod, tMod.getSourceBranch() - 1, isPWave, false);
            TauBranch aboveSourceBranchP = tMod.getTauBranch(tMod.getSourceBranch() - 1, isPWave);
            if (this.receiverBranch == tMod.sourceBranch - 1) {
                upProto = ProtoSeismicPhase.start(new SeismicPhaseSegment(tMod, aboveStartBranch, aboveStartBranch, isPWave, PhaseInteraction.END, false, SeismicPhaseWalk.legNameForTauBranch(tMod, tMod.getSourceBranch(), isPWave, false, false), 0.0, aboveSourceBranchP.getMinTurnRayParam()), receiverDepth);
                segmentTree.add(upProto);
            }
            if (!this.excludeBranch.contains(aboveStartBranch)) {
                ProtoSeismicPhase reflProto = ProtoSeismicPhase.start(new SeismicPhaseSegment(tMod, aboveStartBranch, aboveStartBranch, isPWave, PhaseInteraction.REFLECT_UNDERSIDE, false, SeismicPhaseWalk.legNameForTauBranch(tMod, tMod.getSourceBranch(), isPWave, false, false), 0.0, aboveSourceBranchP.getMinTurnRayParam()), receiverDepth);
                segmentTree.add(reflProto);
            }
            if (tMod.getSourceBranch() > 1) {
                upProto = ProtoSeismicPhase.start(new SeismicPhaseSegment(tMod, aboveStartBranch, aboveStartBranch, isPWave, PhaseInteraction.TRANSUP, false, SeismicPhaseWalk.legNameForTauBranch(tMod, tMod.getSourceBranch(), isPWave, false, false), 0.0, aboveSourceBranchP.getMinTurnRayParam()), receiverDepth);
                segmentTree.add(upProto);
            }
        }
        int startBranch = tMod.getSourceBranch();
        TauBranch sourceBranchP = tMod.getTauBranch(tMod.getSourceBranch(), isPWave);
        int endBranchNum = ProtoSeismicPhase.findEndDiscon(tMod, tMod.getSourceBranch(), isPWave, true);
        ProtoSeismicPhase turnProto = ProtoSeismicPhase.start(new SeismicPhaseSegment(tMod, startBranch, endBranchNum, isPWave, PhaseInteraction.TURN, true, SeismicPhaseWalk.legNameForTauBranch(tMod, tMod.getSourceBranch(), isPWave, true, false), sourceBranchP.getMinRayParam(), sourceBranchP.getMaxRayParam()), receiverDepth);
        segmentTree.add(turnProto);
        if (this.receiverBranch == endBranchNum + 1) {
            ProtoSeismicPhase endProto = ProtoSeismicPhase.start(new SeismicPhaseSegment(tMod, startBranch, startBranch, isPWave, PhaseInteraction.END, true, SeismicPhaseWalk.legNameForTauBranch(tMod, tMod.getSourceBranch(), isPWave, true, false), sourceBranchP.getMinRayParam(), sourceBranchP.getMaxRayParam()), receiverDepth);
            segmentTree.add(endProto);
        }
        if (tMod.getSourceBranch() < tMod.getNumBranches() - 1) {
            if (!this.excludeBranch.contains(endBranchNum + 1)) {
                ProtoSeismicPhase reflProto = ProtoSeismicPhase.start(new SeismicPhaseSegment(tMod, startBranch, endBranchNum, isPWave, PhaseInteraction.REFLECT_TOPSIDE, true, SeismicPhaseWalk.legNameForTauBranch(tMod, tMod.getSourceBranch(), isPWave, true, false), 0.0, sourceBranchP.getMinTurnRayParam()), receiverDepth);
                segmentTree.add(reflProto);
            }
            ProtoSeismicPhase transDProto = ProtoSeismicPhase.start(new SeismicPhaseSegment(tMod, startBranch, endBranchNum, isPWave, PhaseInteraction.TRANSDOWN, true, SeismicPhaseWalk.legNameForTauBranch(tMod, tMod.getSourceBranch(), isPWave, true, false), 0.0, sourceBranchP.getMinRayParam()), receiverDepth);
            segmentTree.add(transDProto);
        }
        return segmentTree;
    }

    public List<ProtoSeismicPhase> cleanDuplicates(List<ProtoSeismicPhase> in) {
        ArrayList<ProtoSeismicPhase> out = new ArrayList<ProtoSeismicPhase>();
        ArrayList<ProtoSeismicPhase> sameSize = new ArrayList<ProtoSeismicPhase>();
        int currSize = in.get(0).size();
        for (ProtoSeismicPhase next : in) {
            if (currSize == next.size()) {
                ArrayList<ProtoSeismicPhase> merged = new ArrayList<ProtoSeismicPhase>();
                for (ProtoSeismicPhase p : sameSize) {
                    if (this.canMergePhases(p, next)) {
                        next = this.mergePhases(p, next);
                        continue;
                    }
                    merged.add(p);
                }
                merged.add(next);
                sameSize = merged;
                continue;
            }
            out.addAll(sameSize);
            sameSize.clear();
            sameSize.add(next);
            currSize = next.size();
        }
        out.addAll(sameSize);
        return out;
    }

    public boolean canMergePhases(ProtoSeismicPhase curr, ProtoSeismicPhase other) {
        if (curr.size() == other.size() - 1 && curr.get((int)0).endAction == PhaseInteraction.TURN && other.get((int)0).endAction == PhaseInteraction.TRANSDOWN && curr.get((int)0).endBranch == other.get((int)0).endBranch && curr.get((int)0).isPWave == other.get((int)0).isPWave) {
            for (int s = 0; s < curr.size() && s < other.size() - 1; ++s) {
                SeismicPhaseSegment cS = curr.get(s);
                SeismicPhaseSegment oS = other.get(s + 1);
                if (cS.isPWave == oS.isPWave && cS.isDownGoing == oS.isDownGoing && cS.endAction == oS.endAction && Objects.equals(cS.legName.substring(0, 1), oS.legName)) continue;
                return false;
            }
            return true;
        }
        if (curr.size() != other.size()) {
            return false;
        }
        SeismicPhaseSegment pS = null;
        for (int s = 0; s < curr.size(); ++s) {
            SeismicPhaseSegment cS = curr.get(s);
            SeismicPhaseSegment oS = other.get(s);
            if (cS.isPWave != oS.isPWave || cS.isDownGoing != oS.isDownGoing || cS.endAction != oS.endAction || !Objects.equals(cS.legName, oS.legName)) {
                return false;
            }
            if (cS.isDownGoing) {
                if (cS.startBranch != oS.startBranch) {
                    return false;
                }
                if (cS.endAction != PhaseInteraction.TURN && cS.endBranch != oS.endBranch) {
                    return false;
                }
            } else {
                if (cS.endBranch != oS.endBranch) {
                    return false;
                }
                if (pS == null && cS.startBranch != oS.startBranch) {
                    return false;
                }
                if (pS != null && pS.endAction != PhaseInteraction.TURN && cS.startBranch != oS.startBranch) {
                    return false;
                }
            }
            pS = cS;
        }
        return true;
    }

    public ProtoSeismicPhase mergePhases(ProtoSeismicPhase curr, ProtoSeismicPhase other) {
        ArrayList<SeismicPhaseSegment> out = new ArrayList<SeismicPhaseSegment>();
        SeismicPhaseSegment prevS = null;
        for (int s = 0; s < curr.size(); ++s) {
            SeismicPhaseSegment m;
            SeismicPhaseSegment cS = curr.get(s);
            SeismicPhaseSegment oS = other.get(s);
            if (cS.endAction == PhaseInteraction.TURN) {
                if (cS.endBranch == oS.endBranch) {
                    out.add(cS);
                } else if (cS.endBranch < oS.endBranch) {
                    m = new SeismicPhaseSegment(cS.tMod, cS.startBranch, oS.endBranch, cS.isPWave, cS.endAction, cS.isDownGoing, cS.legName, oS.minRayParam, cS.maxRayParam);
                    out.add(m);
                } else {
                    m = new SeismicPhaseSegment(cS.tMod, cS.startBranch, oS.endBranch, cS.isPWave, cS.endAction, cS.isDownGoing, cS.legName, cS.minRayParam, oS.maxRayParam);
                    out.add(m);
                }
            } else if (prevS != null && (prevS.endAction == PhaseInteraction.TURN || prevS.endAction == PhaseInteraction.DIFFRACTTURN)) {
                if (cS.startBranch == oS.startBranch) {
                    out.add(cS);
                } else if (cS.startBranch < oS.startBranch) {
                    m = new SeismicPhaseSegment(cS.tMod, oS.startBranch, oS.endBranch, cS.isPWave, cS.endAction, cS.isDownGoing, cS.legName, oS.minRayParam, cS.maxRayParam);
                    out.add(m);
                } else {
                    m = new SeismicPhaseSegment(cS.tMod, oS.startBranch, oS.endBranch, cS.isPWave, cS.endAction, cS.isDownGoing, cS.legName, cS.minRayParam, oS.maxRayParam);
                    out.add(m);
                }
            } else {
                out.add(cS);
            }
            prevS = cS;
        }
        return new ProtoSeismicPhase(out, 0.0);
    }

    public List<ProtoSeismicPhase> walkPhases(TauModel tMod, List<ProtoSeismicPhase> segmentTree, int maxLegs) throws TauModelException {
        List<ProtoSeismicPhase> nextSegmentTree = new ArrayList<ProtoSeismicPhase>();
        boolean walkedAStep = false;
        for (ProtoSeismicPhase segList : segmentTree) {
            SeismicPhaseSegment endSeg = segList.get(segList.size() - 1);
            if (endSeg.endAction == PhaseInteraction.END || endSeg.endAction == PhaseInteraction.END_DOWN) {
                nextSegmentTree.add(segList);
                continue;
            }
            int interactionNum = segList.calcInteractionNumber();
            if (interactionNum > maxLegs) continue;
            segList.validateSegList();
            ArrayList<ProtoSeismicPhase> calcedNext = new ArrayList<ProtoSeismicPhase>();
            if (this.allowPWave) {
                calcedNext.addAll(this.nextLegs(tMod, segList, true));
            }
            if (this.allowSWave) {
                calcedNext.addAll(this.nextLegs(tMod, segList, false));
            }
            for (ProtoSeismicPhase calcSegList : calcedNext) {
                ProtoSeismicPhase conProto;
                SeismicPhaseSegment calcendSeg = calcSegList.get(calcSegList.size() - 1);
                if (calcSegList.calcInteractionNumber() <= maxLegs && calcendSeg.minRayParam < calcendSeg.maxRayParam) {
                    conProto = this.consolidateSegment(calcSegList);
                    nextSegmentTree.add(conProto);
                    walkedAStep = true;
                    continue;
                }
                if (!TauPConfig.DEBUG) continue;
                conProto = this.consolidateSegment(calcSegList);
                System.out.println("skip " + conProto.phaseNameForSegments() + " " + (calcSegList.calcInteractionNumber() <= maxLegs) + " " + (calcendSeg.minRayParam < calcendSeg.maxRayParam));
            }
        }
        nextSegmentTree = this.overlapsRayParam(nextSegmentTree, this.minRayParam, this.maxRayParam);
        if (walkedAStep) {
            nextSegmentTree = this.walkPhases(tMod, nextSegmentTree, maxLegs);
        }
        return nextSegmentTree;
    }

    public List<ProtoSeismicPhase> overlapsRayParam(List<ProtoSeismicPhase> segTree, Double minRayParam, Double maxRayParam) {
        ArrayList<ProtoSeismicPhase> out = new ArrayList<ProtoSeismicPhase>();
        for (ProtoSeismicPhase segList : segTree) {
            SeismicPhaseSegment endSeg = segList.get(segList.size() - 1);
            if (minRayParam != null && !(endSeg.maxRayParam >= minRayParam) || maxRayParam != null && !(endSeg.minRayParam <= maxRayParam)) continue;
            out.add(segList);
        }
        return out;
    }

    public List<ProtoSeismicPhase> nextLegs(TauModel tMod, ProtoSeismicPhase proto, boolean isPWave) throws TauModelException {
        int startBranchNum;
        ArrayList<ProtoSeismicPhase> outTree = new ArrayList<ProtoSeismicPhase>();
        SeismicPhaseSegment prevEndSeg = proto.get(proto.size() - 1);
        if (isPWave != prevEndSeg.isPWave) {
            if (prevEndSeg.isDownGoing && this.excludeBranch.contains(prevEndSeg.endBranch + 1)) {
                return outTree;
            }
            if (!prevEndSeg.isDownGoing && this.excludeBranch.contains(prevEndSeg.endBranch)) {
                return outTree;
            }
        }
        switch (prevEndSeg.endAction) {
            case TRANSUP: {
                if (prevEndSeg.endBranch == 0) {
                    throw new TauModelException(proto.getName() + " TransUp when prev end is zero, prev: " + prevEndSeg.endBranch + " " + String.valueOf((Object)prevEndSeg.endAction));
                }
                startBranchNum = prevEndSeg.endBranch - 1;
                break;
            }
            case TRANSDOWN: {
                startBranchNum = prevEndSeg.endBranch + 1;
                break;
            }
            default: {
                startBranchNum = prevEndSeg.endBranch;
            }
        }
        if (!isPWave && tMod.getSlownessModel().depthInFluid(tMod.getTauBranch(startBranchNum, true).getTopDepth())) {
            return outTree;
        }
        int endBranchNum = ProtoSeismicPhase.findEndDiscon(tMod, startBranchNum, isPWave, PhaseInteraction.isDowngoingActionAfter(prevEndSeg.endAction));
        switch (prevEndSeg.endAction) {
            case TRANSUP: {
                if (this.receiverBranch >= prevEndSeg.endBranch || this.receiverBranch < endBranchNum) break;
                SeismicPhaseWalk.outTreeAdd(outTree, proto.nextSegment(isPWave, PhaseInteraction.END));
                break;
            }
            case TURN: {
                if (this.receiverBranch > prevEndSeg.endBranch || this.receiverBranch < endBranchNum || isPWave != prevEndSeg.isPWave) break;
                SeismicPhaseWalk.outTreeAdd(outTree, proto.nextSegment(prevEndSeg.isPWave, PhaseInteraction.END));
                break;
            }
            case DIFFRACTTURN: {
                if (this.receiverBranch > prevEndSeg.endBranch || this.receiverBranch < endBranchNum) break;
                SeismicPhaseWalk.outTreeAdd(outTree, proto.nextSegment(prevEndSeg.isPWave, PhaseInteraction.END));
                break;
            }
            case REFLECT_TOPSIDE: {
                if (this.receiverBranch > prevEndSeg.endBranch || this.receiverBranch < endBranchNum) break;
                SeismicPhaseWalk.outTreeAdd(outTree, proto.nextSegment(isPWave, PhaseInteraction.END));
                break;
            }
            case REFLECT_UNDERSIDE: {
                if (this.receiverBranch <= prevEndSeg.endBranch || this.receiverBranch > endBranchNum + 1) break;
                SeismicPhaseWalk.outTreeAdd(outTree, proto.nextSegment(isPWave, PhaseInteraction.END));
                break;
            }
            case TRANSDOWN: {
                if (this.receiverBranch <= prevEndSeg.endBranch || this.receiverBranch > endBranchNum + 2) break;
                SeismicPhaseWalk.outTreeAdd(outTree, proto.nextSegment(isPWave, PhaseInteraction.END));
            }
        }
        switch (prevEndSeg.endAction) {
            case END: {
                SeismicPhaseWalk.outTreeAdd(outTree, proto);
            }
            case FAIL: {
                break;
            }
            case TRANSDOWN: 
            case REFLECT_UNDERSIDE: {
                ProtoSeismicPhase turnPhase = proto.nextSegment(isPWave, PhaseInteraction.TURN);
                SeismicPhaseWalk.outTreeAdd(outTree, turnPhase);
                if (prevEndSeg.endBranch >= tMod.getNumBranches() - 2) break;
                SeismicPhaseWalk.outTreeAdd(outTree, proto.nextSegment(isPWave, PhaseInteraction.TRANSDOWN));
                if (this.excludeBranch.contains(1 + ProtoSeismicPhase.findEndDiscon(tMod, startBranchNum, isPWave, true))) break;
                SeismicPhaseWalk.outTreeAdd(outTree, proto.nextSegment(isPWave, PhaseInteraction.REFLECT_TOPSIDE));
                break;
            }
            case TRANSUP: 
            case REFLECT_TOPSIDE: {
                if (startBranchNum > 0 && (isPWave || !tMod.isFluidBranch(startBranchNum))) {
                    SeismicPhaseWalk.outTreeAdd(outTree, proto.nextSegment(isPWave, PhaseInteraction.TRANSUP));
                }
                if (this.excludeBranch.contains(ProtoSeismicPhase.findEndDiscon(tMod, startBranchNum, isPWave, false))) break;
                SeismicPhaseWalk.outTreeAdd(outTree, proto.nextSegment(isPWave, PhaseInteraction.REFLECT_UNDERSIDE));
                break;
            }
            case TURN: {
                int endDiscon;
                if (isPWave != prevEndSeg.isPWave) break;
                if (prevEndSeg.endBranch > 0 && (isPWave || !tMod.isFluidBranch(startBranchNum))) {
                    SeismicPhaseWalk.outTreeAdd(outTree, proto.nextSegment(prevEndSeg.isPWave, PhaseInteraction.TRANSUP));
                }
                if (this.excludeBranch.contains(endDiscon = ProtoSeismicPhase.findEndDiscon(tMod, startBranchNum, isPWave, false))) break;
                SeismicPhaseWalk.outTreeAdd(outTree, proto.nextSegment(prevEndSeg.isPWave, PhaseInteraction.REFLECT_UNDERSIDE));
            }
        }
        return outTree;
    }

    public static void outTreeAdd(List<ProtoSeismicPhase> outTree, ProtoSeismicPhase proto) {
        if (proto != null) {
            boolean hasDiffOrHead = false;
            for (SeismicPhaseSegment seg : proto.segmentList) {
                if (!seg.isFlat) continue;
                hasDiffOrHead = true;
                break;
            }
            SeismicPhaseSegment endSeg = proto.get(proto.size() - 1);
            if (hasDiffOrHead || endSeg.minRayParam < endSeg.maxRayParam) {
                outTree.add(proto);
            }
        }
    }

    public static String legNameForTauBranch(TauModel tMod, int branchNum, boolean isPWave, boolean isDowngoing, boolean isFlat) {
        if (branchNum < 0 || branchNum >= tMod.getNumBranches()) {
            return "unknown";
        }
        TauBranch tauBranch = tMod.getTauBranch(branchNum, isPWave);
        if (branchNum >= tMod.getIocbBranch()) {
            if (tauBranch.isPWave) {
                if (isFlat) {
                    return "I";
                }
                if (isDowngoing) {
                    return "Ied";
                }
                return "y";
            }
            if (isFlat) {
                return "J";
            }
            if (isDowngoing) {
                return "Jed";
            }
            return "j";
        }
        if (branchNum >= tMod.getCmbBranch()) {
            if (tauBranch.isPWave) {
                if (isFlat) {
                    return "K";
                }
                if (isDowngoing) {
                    return "Ked";
                }
                return "k";
            }
            return "[outercore_S]";
        }
        if (tauBranch.isPWave) {
            if (isFlat) {
                return "P";
            }
            if (isDowngoing) {
                return "Ped";
            }
            return "p";
        }
        if (isFlat) {
            return "S";
        }
        if (isDowngoing) {
            return "Sed";
        }
        return "s";
    }

    public ProtoSeismicPhase consolidateSegment(ProtoSeismicPhase proto) throws TauModelException {
        proto.validateSegList();
        ProtoSeismicPhase outSegmentList = this.consolidateTrans(proto);
        outSegmentList.validateSegList();
        return outSegmentList;
    }

    public ProtoSeismicPhase consolidateTrans(ProtoSeismicPhase proto) throws TauModelException {
        ArrayList<SeismicPhaseSegment> out = new ArrayList<SeismicPhaseSegment>();
        SeismicPhaseSegment prev = null;
        for (SeismicPhaseSegment seg : proto.segmentList) {
            if (prev != null && (prev.endAction == PhaseInteraction.TRANSDOWN || prev.endAction == PhaseInteraction.TRANSUP) && prev.isPWave == seg.isPWave && Objects.equals(Character.valueOf(prev.legName.charAt(0)), Character.valueOf(seg.legName.charAt(0)))) {
                SeismicPhaseSegment conSeg = new SeismicPhaseSegment(prev.tMod, prev.startBranch, seg.endBranch, prev.isPWave, seg.endAction, prev.isDownGoing, prev.legName, Math.max(prev.minRayParam, seg.minRayParam), Math.min(prev.maxRayParam, seg.maxRayParam));
                out.remove(prev);
                out.add(conSeg);
                prev = conSeg;
                continue;
            }
            out.add(seg);
            prev = seg;
        }
        ProtoSeismicPhase conProto = new ProtoSeismicPhase(out, 0.0);
        conProto.validateSegList();
        return conProto;
    }

    public boolean isAllowSWave() {
        return this.allowSWave;
    }

    public void setAllowSWave(boolean allowSWave) {
        this.allowSWave = allowSWave;
    }

    public boolean isAllowPWave() {
        return this.allowPWave;
    }

    public void setAllowPWave(boolean allowPWave) {
        this.allowPWave = allowPWave;
    }

    public TauModel gettMod() {
        return this.tMod;
    }

    public List<Integer> getExcludeBranch() {
        return this.excludeBranch;
    }
}

