/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.LinearInterpolation;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class XYSegment {
    public final double[] x;
    public final double[] y;
    public List<String> cssClasses = new ArrayList<String>();
    public String description = "";

    public XYSegment(double[] x, double[] y) {
        this.x = x;
        this.y = y;
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y data must be of equal length: " + x.length + " " + y.length);
        }
    }

    public static XYSegment fromSingleList(List<Double> xData, List<Double> yData) {
        double[] rp = new double[xData.size()];
        for (int j = 0; j < rp.length; ++j) {
            rp[j] = xData.get(j);
        }
        double[] vals = new double[rp.length];
        for (int j = 0; j < yData.size(); ++j) {
            vals[j] = yData.get(j);
        }
        return new XYSegment(rp, vals);
    }

    public static List<XYSegment> createFromLists(List<double[]> xData, List<double[]> yData) {
        if (xData.size() != yData.size()) {
            throw new IllegalArgumentException("xData and yData must have same size: " + xData.size() + " " + yData.size());
        }
        ArrayList<XYSegment> segmentList = new ArrayList<XYSegment>();
        for (int i = 0; i < xData.size(); ++i) {
            segmentList.add(new XYSegment(xData.get(i), yData.get(i)));
        }
        return segmentList;
    }

    public List<XYSegment> trimToMinMax(double[] xAxisMinMax, double[] yAxisMinMax) {
        double[] yarr;
        int i;
        ArrayList<XYSegment> outList = new ArrayList<XYSegment>();
        ArrayList<Double> outX = new ArrayList<Double>();
        ArrayList<Double> outY = new ArrayList<Double>();
        if (xAxisMinMax.length == 2 && yAxisMinMax.length == 0) {
            for (i = 0; i < this.x.length; ++i) {
                if (xAxisMinMax[0] <= this.x[i] && this.x[i] < xAxisMinMax[1]) {
                    if (i > 0) {
                        if (this.x[i - 1] < xAxisMinMax[0] && xAxisMinMax[0] < this.x[i]) {
                            outX.add(xAxisMinMax[0]);
                            double yInterp = LinearInterpolation.linearInterp(this.x[i - 1], this.y[i - 1], this.x[i], this.y[i], xAxisMinMax[0]);
                            outY.add(yInterp);
                        } else if (this.x[i - 1] > xAxisMinMax[1] && xAxisMinMax[1] > this.x[i]) {
                            double yInterp = LinearInterpolation.linearInterp(this.x[i - 1], this.y[i - 1], this.x[i], this.y[i], xAxisMinMax[1]);
                            outX.add(xAxisMinMax[1]);
                            outY.add(yInterp);
                        }
                    }
                    outX.add(this.x[i]);
                    outY.add(this.y[i]);
                    continue;
                }
                if (outX.isEmpty()) continue;
                if (i > 0) {
                    if (this.x[i - 1] > xAxisMinMax[0] && xAxisMinMax[0] > this.x[i]) {
                        outX.add(xAxisMinMax[0]);
                        double yInterp = LinearInterpolation.linearInterp(this.x[i - 1], this.y[i - 1], this.x[i], this.y[i], xAxisMinMax[0]);
                        outY.add(yInterp);
                    } else if (this.x[i - 1] < xAxisMinMax[1] && xAxisMinMax[1] < this.x[i]) {
                        double yInterp = LinearInterpolation.linearInterp(this.x[i - 1], this.y[i - 1], this.x[i], this.y[i], xAxisMinMax[1]);
                        outX.add(xAxisMinMax[1]);
                        outY.add(yInterp);
                    }
                }
                double[] xarr = Stream.of(outX.toArray(new Double[0])).mapToDouble(Double::doubleValue).toArray();
                yarr = Stream.of(outY.toArray(new Double[0])).mapToDouble(Double::doubleValue).toArray();
                XYSegment trimSeg = new XYSegment(xarr, yarr);
                trimSeg.cssClasses = this.cssClasses;
                trimSeg.description = this.description;
                outList.add(trimSeg);
                outX = new ArrayList();
                outY = new ArrayList();
            }
        } else if (xAxisMinMax.length == 0 && yAxisMinMax.length == 2) {
            for (i = 0; i < this.x.length; ++i) {
                if (yAxisMinMax[0] <= this.y[i] && this.y[i] <= yAxisMinMax[1]) {
                    if (i > 0) {
                        if (this.y[i - 1] < yAxisMinMax[0] && yAxisMinMax[0] < this.y[i]) {
                            outY.add(yAxisMinMax[0]);
                            double xInterp = LinearInterpolation.linearInterp(this.y[i - 1], this.x[i - 1], this.y[i], this.x[i], yAxisMinMax[0]);
                            outX.add(xInterp);
                        } else if (this.y[i - 1] > yAxisMinMax[1] && yAxisMinMax[1] > this.y[i]) {
                            double xInterp = LinearInterpolation.linearInterp(this.y[i - 1], this.x[i - 1], this.y[i], this.x[i], yAxisMinMax[1]);
                            outY.add(yAxisMinMax[1]);
                            outX.add(xInterp);
                        }
                    }
                    outX.add(this.x[i]);
                    outY.add(this.y[i]);
                    continue;
                }
                if (outX.size() <= 0) continue;
                if (i > 0) {
                    if (this.y[i - 1] > yAxisMinMax[0] && yAxisMinMax[0] > this.y[i]) {
                        outY.add(yAxisMinMax[0]);
                        double xInterp = LinearInterpolation.linearInterp(this.y[i - 1], this.x[i - 1], this.y[i], this.x[i], yAxisMinMax[0]);
                        outX.add(xInterp);
                    } else if (this.y[i - i] < yAxisMinMax[1] && yAxisMinMax[1] < this.y[i]) {
                        double xInterp = LinearInterpolation.linearInterp(this.y[i - 1], this.x[i - 1], this.y[i], this.x[i], yAxisMinMax[1]);
                        outY.add(yAxisMinMax[1]);
                        outX.add(xInterp);
                    }
                }
                double[] xarr = Stream.of(outX.toArray(new Double[0])).mapToDouble(Double::doubleValue).toArray();
                yarr = Stream.of(outY.toArray(new Double[0])).mapToDouble(Double::doubleValue).toArray();
                XYSegment trimSeg = new XYSegment(xarr, yarr);
                trimSeg.cssClasses = this.cssClasses;
                trimSeg.description = this.description;
                outList.add(trimSeg);
                outX = new ArrayList();
                outY = new ArrayList();
            }
        } else if (xAxisMinMax.length == 2 && yAxisMinMax.length == 2) {
            for (i = 0; i < this.x.length; ++i) {
                if (xAxisMinMax[0] <= this.x[i] && this.x[i] < xAxisMinMax[1] && yAxisMinMax[0] <= this.y[i] && this.y[i] <= yAxisMinMax[1]) {
                    if (i > 0) {
                        if (this.x[i - 1] < xAxisMinMax[0] && xAxisMinMax[0] < this.x[i]) {
                            outX.add(xAxisMinMax[0]);
                            double yInterp = LinearInterpolation.linearInterp(this.x[i - 1], this.y[i - 1], this.x[i], this.y[i], xAxisMinMax[0]);
                            outY.add(yInterp);
                        } else if (this.x[i - 1] > xAxisMinMax[1] && xAxisMinMax[1] > this.x[i]) {
                            double yInterp = LinearInterpolation.linearInterp(this.x[i - 1], this.y[i - 1], this.x[i], this.y[i], xAxisMinMax[1]);
                            outX.add(xAxisMinMax[1]);
                            outY.add(yInterp);
                        } else if (this.y[i - 1] < yAxisMinMax[0] && yAxisMinMax[0] < this.y[i]) {
                            outY.add(yAxisMinMax[0]);
                            double xInterp = LinearInterpolation.linearInterp(this.y[i - 1], this.x[i - 1], this.y[i], this.x[i], yAxisMinMax[0]);
                            outX.add(xInterp);
                        } else if (this.y[i - 1] > yAxisMinMax[1] && yAxisMinMax[1] > this.y[i]) {
                            double xInterp = LinearInterpolation.linearInterp(this.y[i - 1], this.x[i - 1], this.y[i], this.x[i], yAxisMinMax[1]);
                            outY.add(yAxisMinMax[1]);
                            outX.add(xInterp);
                        }
                    }
                    outX.add(this.x[i]);
                    outY.add(this.y[i]);
                    continue;
                }
                if (outX.size() <= 0) continue;
                if (i > 0) {
                    if (this.x[i - 1] > xAxisMinMax[0] && xAxisMinMax[0] > this.x[i]) {
                        outX.add(xAxisMinMax[0]);
                        double yInterp = LinearInterpolation.linearInterp(this.x[i - 1], this.y[i - 1], this.x[i], this.y[i], xAxisMinMax[0]);
                        outY.add(yInterp);
                    } else if (this.x[i - i] < xAxisMinMax[1] && xAxisMinMax[1] < this.x[i]) {
                        double yInterp = LinearInterpolation.linearInterp(this.x[i - 1], this.y[i - 1], this.x[i], this.y[i], xAxisMinMax[1]);
                        outX.add(xAxisMinMax[1]);
                        outY.add(yInterp);
                    } else if (this.y[i - 1] > yAxisMinMax[0] && yAxisMinMax[0] > this.y[i]) {
                        outY.add(yAxisMinMax[0]);
                        double xInterp = LinearInterpolation.linearInterp(this.y[i - 1], this.x[i - 1], this.y[i], this.x[i], yAxisMinMax[0]);
                        outX.add(xInterp);
                    } else if (this.y[i - i] < yAxisMinMax[1] && yAxisMinMax[1] < this.y[i]) {
                        double xInterp = LinearInterpolation.linearInterp(this.y[i - 1], this.x[i - 1], this.y[i], this.x[i], yAxisMinMax[1]);
                        outY.add(yAxisMinMax[1]);
                        outX.add(xInterp);
                    }
                }
                double[] xarr = Stream.of(outX.toArray(new Double[0])).mapToDouble(Double::doubleValue).toArray();
                yarr = Stream.of(outY.toArray(new Double[0])).mapToDouble(Double::doubleValue).toArray();
                XYSegment trimSeg = new XYSegment(xarr, yarr);
                trimSeg.cssClasses = this.cssClasses;
                trimSeg.description = this.description;
                outList.add(trimSeg);
                outX = new ArrayList();
                outY = new ArrayList();
            }
        } else {
            return List.of(this);
        }
        if (outX.size() > 0) {
            double[] xarr = Stream.of(outX.toArray(new Double[0])).mapToDouble(Double::doubleValue).toArray();
            double[] yarr2 = Stream.of(outY.toArray(new Double[0])).mapToDouble(Double::doubleValue).toArray();
            XYSegment trimSeg = new XYSegment(xarr, yarr2);
            trimSeg.cssClasses = this.cssClasses;
            trimSeg.description = this.description;
            outList.add(trimSeg);
        }
        return outList;
    }

    public double[] minMax(double[] priorMinMax) {
        double minX = priorMinMax[0];
        double maxX = priorMinMax[1];
        double minY = priorMinMax[2];
        double maxY = priorMinMax[3];
        for (int i = 0; i < this.x.length; ++i) {
            if (Double.isFinite(this.x[i])) {
                if (this.x[i] < minX) {
                    minX = this.x[i];
                }
                if (this.x[i] > maxX) {
                    maxX = this.x[i];
                }
            }
            if (!Double.isFinite(this.y[i])) continue;
            if (this.y[i] < minY) {
                minY = this.y[i];
            }
            if (!(this.y[i] > maxY)) continue;
            maxY = this.y[i];
        }
        return new double[]{minX, maxX, minY, maxY};
    }

    public double[] minMaxInXRange(double[] priorMinMax, double[] xRange) {
        double minY = priorMinMax[2];
        double maxY = priorMinMax[3];
        for (int i = 0; i < this.y.length; ++i) {
            if (i > 0) {
                for (int j = 0; j < 2; ++j) {
                    if (!(this.x[i - 1] < xRange[j] && xRange[j] < this.x[i]) && (!(xRange[j] > this.x[i]) || !(this.x[i - 1] > xRange[j]))) continue;
                    double interp = LinearInterpolation.linearInterp(this.x[i - 1], this.y[i - 1], this.x[i], this.y[i], xRange[j]);
                    if (interp < minY) {
                        minY = interp;
                    }
                    if (!(interp > maxY)) continue;
                    maxY = interp;
                }
            }
            if (!((this.x[i] - xRange[0]) * (this.x[i] - xRange[1]) < 0.0)) continue;
            if (this.y[i] < minY) {
                minY = this.y[i];
            }
            if (!(this.y[i] > maxY)) continue;
            maxY = this.y[i];
        }
        return new double[]{xRange[0], xRange[1], minY, maxY};
    }

    public double[] minMaxInYRange(double[] priorMinMax, double[] yRange) {
        double minX = priorMinMax[0];
        double maxX = priorMinMax[1];
        for (int i = 0; i < this.x.length; ++i) {
            if (i > 0) {
                for (int j = 0; j < 2; ++j) {
                    if (!(this.y[i - 1] < yRange[j] && yRange[j] < this.y[i]) && (!(yRange[j] > this.y[i]) || !(this.y[i - 1] > yRange[j]))) continue;
                    double interp = LinearInterpolation.linearInterp(this.y[i - 1], this.x[i - 1], this.y[i], this.x[i], yRange[j]);
                    if (interp < minX) {
                        minX = interp;
                    }
                    if (!(interp > maxX)) continue;
                    maxX = interp;
                }
            }
            if (!((this.y[i] - yRange[0]) * (this.y[i] - yRange[1]) < 0.0)) continue;
            if (this.x[i] < minX) {
                minX = this.x[i];
            }
            if (!(this.x[i] > maxX)) continue;
            maxX = this.x[i];
        }
        return new double[]{minX, maxX, yRange[0], yRange[1]};
    }

    public XYSegment recalcForAbs(boolean xAxisAbs, boolean yAxisAbs) {
        double[] outX = new double[this.x.length];
        double[] outY = new double[this.y.length];
        for (int i = 0; i < this.x.length; ++i) {
            outX[i] = xAxisAbs ? Math.abs(this.x[i]) : this.x[i];
            outY[i] = yAxisAbs ? Math.abs(this.y[i]) : this.y[i];
        }
        return new XYSegment(outX, outY);
    }

    public XYSegment recalcForLog(boolean xAxisLog, boolean yAxisLog) {
        double[] outX = new double[this.x.length];
        double[] outY = new double[this.y.length];
        for (int i = 0; i < this.x.length; ++i) {
            outX[i] = xAxisLog ? Math.log10(Math.abs(this.x[i])) : this.x[i];
            outY[i] = yAxisLog ? Math.log10(Math.abs(this.y[i])) : this.y[i];
        }
        return new XYSegment(outX, outY);
    }

    public List<XYSegment> recalcForInfinite(boolean xAxisSplitZero, boolean yAxisSplitZero) {
        ArrayList<XYSegment> out = new ArrayList<XYSegment>();
        double[] outX = new double[this.x.length];
        double[] outY = new double[this.y.length];
        int tmpOffset = 0;
        for (int i = 0; i < this.x.length; ++i) {
            if (xAxisSplitZero && this.x[i] == 0.0 || yAxisSplitZero && this.y[i] == 0.0 || !Double.isFinite(this.x[i]) || !Double.isFinite(this.y[i])) {
                if (tmpOffset > 0) {
                    double[] prex = new double[tmpOffset];
                    System.arraycopy(outX, 0, prex, 0, prex.length);
                    double[] prey = new double[tmpOffset];
                    System.arraycopy(outY, 0, prey, 0, prey.length);
                    out.add(new XYSegment(prex, prey));
                }
                double[] postx = new double[outX.length - tmpOffset - 1];
                System.arraycopy(outX, tmpOffset + 1, postx, 0, postx.length);
                double[] posty = new double[outX.length - tmpOffset - 1];
                System.arraycopy(outY, tmpOffset + 1, posty, 0, posty.length);
                outX = postx;
                outY = posty;
                tmpOffset = 0;
                continue;
            }
            outX[tmpOffset] = this.x[i];
            outY[tmpOffset] = this.y[i];
            ++tmpOffset;
        }
        if (outX.length > 0) {
            out.add(new XYSegment(outX, outY));
        }
        return out;
    }

    public static XYSegment radianDepthToXY(XYSegment segment, double R) {
        double[] xVal = new double[segment.x.length];
        double[] yVal = new double[xVal.length];
        for (int i = 0; i < xVal.length; ++i) {
            double radius = R - segment.y[i];
            double radian = segment.x[i] - 1.5707963267948966;
            xVal[i] = radius * Math.cos(radian);
            yVal[i] = radius * Math.sin(radian);
        }
        XYSegment out = new XYSegment(xVal, yVal);
        out.cssClasses = List.copyOf(segment.cssClasses);
        out.description = segment.description;
        return out;
    }

    public void asSVG(PrintWriter writer, String css_class) {
        this.asSVG(writer, css_class, "%f", "%f");
    }

    public void asSVG(PrintWriter writer, String css_class, String xFormat, String yFormat) {
        Object cssClassParam = css_class;
        if (this.cssClasses != null && !this.cssClasses.isEmpty()) {
            cssClassParam = "";
            for (String s : this.cssClasses) {
                cssClassParam = (String)cssClassParam + " " + s;
            }
        }
        if (!((String)(cssClassParam = ((String)cssClassParam).trim())).isEmpty()) {
            cssClassParam = "class=\"" + (String)cssClassParam + "\"";
        }
        writer.println("  <g>");
        writer.println("    <desc>" + this.description + "</desc>");
        writer.println("    <polyline " + (String)cssClassParam + " points=\"");
        boolean priorIsFinite = true;
        for (int i = 0; i < this.x.length; ++i) {
            float xf = (float)this.x[i];
            float yf = (float)this.y[i];
            if (Float.isFinite(xf) && Float.isFinite(yf)) {
                writer.println(xf + "  " + yf);
                priorIsFinite = true;
                continue;
            }
            if (i == 0 || i == this.x.length || !priorIsFinite) continue;
            writer.println("  \"  /> <!-- " + css_class + "-->");
            writer.println("    <polyline " + (String)cssClassParam + " points=\"");
        }
        writer.println("  \"  /> <!-- " + (String)cssClassParam + "-->");
        writer.println("  </g>");
    }

    public void asGMT(PrintWriter writer, String label) {
        this.asGMT(writer, label, "%3g", "%3g");
    }

    public void asGMT(PrintWriter writer, String label, String xFormat, String yFormat) {
        writer.println("> " + label);
        for (int i = 0; i < this.x.length; ++i) {
            float xf = (float)this.x[i];
            float yf = (float)this.y[i];
            boolean priorIsFinite = true;
            if (Float.isFinite(xf) && Float.isFinite(yf)) {
                writer.println(String.format(xFormat + "  " + yFormat, Float.valueOf(xf), Float.valueOf(yf)));
                priorIsFinite = true;
                continue;
            }
            if (i == 0 || i == this.x.length || !priorIsFinite) continue;
            writer.println("> " + label + " NaN break " + xf + " " + yf);
        }
    }
}

