/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import edu.sc.seis.TauP.FaultPlane;
import edu.sc.seis.TauP.SeismicSource;
import java.lang.reflect.Type;

public class SeismicSourceSerializer
implements JsonSerializer<SeismicSource> {
    public JsonElement serialize(SeismicSource src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("Mw", (Number)src.getMw());
        if (src.hasNodalPlane()) {
            FaultPlane faultPlane = src.getNodalPlane1();
            JsonObject jsonSDR = new JsonObject();
            json.add("fault", (JsonElement)jsonSDR);
            jsonSDR.addProperty("strike", (Number)faultPlane.getStrike());
            jsonSDR.addProperty("dip", (Number)faultPlane.getDip());
            jsonSDR.addProperty("rake", (Number)faultPlane.getRake());
        }
        json.addProperty("attenuationfreq", (Number)Float.valueOf(src.getAttenuationFrequency()));
        json.addProperty("attenuationnumfreq", (Number)src.getNumFrequencies());
        return json;
    }
}

