package edu.sc.seis.TauP;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class FruitTest {

    public static final String fruitModel = "fruit";
    public static final String fruitModelFile = fruitModel+".nd";

    public SlownessModel sMod;
    public TauModel tMod;

    @BeforeEach
    public void setUp() throws Exception {
        VelocityModel vMod = VelocityModelTest.loadTestVelMod(fruitModelFile);
        tMod = TauModelLoader.createTauModel(vMod);
        sMod = tMod.getSlownessModel();
    }

    @Test
    public void highSlowDepth() throws Exception {
        DepthRange highSlowRange = sMod.highSlownessLayerDepthsP.get(0);
        assertTrue(sMod.depthInHighSlowness(1360,18, true), "a");
        assertTrue(sMod.depthInHighSlowness(1360,highSlowRange.rayParam+0.00000001, true), "b");
        assertFalse(sMod.depthInHighSlowness(1360,highSlowRange.rayParam, true), "c");
        assertFalse(sMod.depthInHighSlowness(1360,highSlowRange.rayParam-0.00000001, true), "d");
    }

    @Test
    public void noMantleP() throws Exception {
        SimpleSeismicPhase P = SeismicPhaseFactory.createPhase("P", tMod);
        double tol = 0.01;
        assertInstanceOf(SimpleContigSeismicPhase.class, P);
        SimpleContigSeismicPhase preshadow = (SimpleContigSeismicPhase)P;
        System.err.println("preshad:  "+preshadow.getMinRayParam()+" "+preshadow.getMaxRayParam());
        assertEquals(0.0, P.getMinDistanceDeg(), tol);
        assertEquals(0.0, preshadow.getMinDistanceDeg(), tol);
        assertEquals(72.66, preshadow.getMaxDistanceDeg(), tol);

        assertEquals(0, P.getInitialPhaseSegment().startBranch);
        assertEquals(0, P.getInitialPhaseSegment().endBranch);
        assertEquals(0, P.getFinalPhaseSegment().startBranch);
        assertEquals(0, P.getFinalPhaseSegment().endBranch);
    }

}
