import { Measure } from '../convert.js';
import { AccelerationSystems, AccelerationUnits } from './acceleration.js';
import { AngleSystems, AngleUnits } from './angle.js';
import { ApparentPowerSystems, ApparentPowerUnits } from './apparentPower.js';
import { AreaSystems, AreaUnits } from './area.js';
import { ChargeSystems, ChargeUnits } from './charge.js';
import { CurrentSystems, CurrentUnits } from './current.js';
import { DigitalSystems, DigitalUnits } from './digital.js';
import { EachSystems, EachUnits } from './each.js';
import { EnergySystems, EnergyUnits } from './energy.js';
import { ForceSystems, ForceUnits } from './force.js';
import { FrequencySystems, FrequencyUnits } from './frequency.js';
import { IlluminanceSystems, IlluminanceUnits } from './illuminance.js';
import { LengthSystems, LengthUnits } from './length.js';
import { MassSystems, MassUnits } from './mass.js';
import { MassFlowRateSystems, MassFlowRateUnits } from './massFlowRate.js';
import { PaceSystems, PaceUnits } from './pace.js';
import { PartsPerSystems, PartsPerUnits } from './partsPer.js';
import { PiecesSystems, PiecesUnits } from './pieces.js';
import { PowerSystems, PowerUnits } from './power.js';
import { PressureSystems, PressureUnits } from './pressure.js';
import { ReactiveEnergySystems, ReactiveEnergyUnits } from './reactiveEnergy.js';
import { ReactivePowerSystems, ReactivePowerUnits } from './reactivePower.js';
import { SpeedSystems, SpeedUnits } from './speed.js';
import { TemperatureSystems, TemperatureUnits } from './temperature.js';
import { TimeSystems, TimeUnits } from './time.js';
import { TorqueSystems, TorqueUnits } from './torque.js';
import { VoltageSystems, VoltageUnits } from './voltage.js';
import { VolumeSystems, VolumeUnits } from './volume.js';
import { VolumeFlowRateSystems, VolumeFlowRateUnits } from './volumeFlowRate.js';
export type AllMeasuresSystems = AccelerationSystems | AngleSystems | ApparentPowerSystems | AreaSystems | ChargeSystems | CurrentSystems | DigitalSystems | EachSystems | EnergySystems | ForceSystems | FrequencySystems | IlluminanceSystems | LengthSystems | MassSystems | MassFlowRateSystems | PaceSystems | PartsPerSystems | PiecesSystems | PowerSystems | PressureSystems | ReactiveEnergySystems | ReactivePowerSystems | SpeedSystems | TorqueSystems | TemperatureSystems | TimeSystems | VoltageSystems | VolumeSystems | VolumeFlowRateSystems;
export type AllMeasuresUnits = AccelerationUnits | AngleUnits | ApparentPowerUnits | AreaUnits | ChargeUnits | CurrentUnits | DigitalUnits | EachUnits | EnergyUnits | ForceUnits | FrequencyUnits | IlluminanceUnits | LengthUnits | MassUnits | MassFlowRateUnits | PaceUnits | PartsPerUnits | PiecesUnits | PowerUnits | PressureUnits | ReactiveEnergyUnits | ReactivePowerUnits | SpeedUnits | TorqueUnits | TemperatureUnits | TimeUnits | VoltageUnits | VolumeUnits | VolumeFlowRateUnits;
export type AllMeasures = 'acceleration' | 'angle' | 'apparentPower' | 'area' | 'charge' | 'current' | 'digital' | 'each' | 'energy' | 'force' | 'frequency' | 'illuminance' | 'length' | 'mass' | 'massFlowRate' | 'pace' | 'partsPer' | 'pieces' | 'power' | 'pressure' | 'reactiveEnergy' | 'reactivePower' | 'speed' | 'torque' | 'temperature' | 'time' | 'voltage' | 'volume' | 'volumeFlowRate';
declare const allMeasures: Record<AllMeasures, Measure<AllMeasuresSystems, AllMeasuresUnits>>;
export default allMeasures;
